
/*
Copyright (c) 2010 IVA2K
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef _STREAMSERVER_H_
#define _STREAMSERVER_H_

#include "if/net/net.h"
#include "api/TCPSocket.h"

#include <string>
using std::string;

#include <list>
using std::list;

class StreamRequestDispatcher;

class StreamServer
{
public:
  StreamServer();
  ~StreamServer();

  typedef list<StreamRequestDispatcher*> tClients;

//  template<typename T>
//  void addHandler(const char* path) //Template decl in header
//  { m_lpHandlers[path] = &T::inst; }
  
  void bind(int port = 123);
  void sendToAll(const char* buf, int len);
  int countClients(void);
  
private:
  friend class StreamRequestDispatcher;

  void onTcpSocketEvent(TCPSocketEvent e);
  
  TCPSocket* m_pTcpSocket;
  tClients m_lpClients;
  
};

//BEGIN REQUEST DISPATCHER======================================================
#include "mbed.h"
class StreamRequestDispatcher : public NetService
{
public:
  StreamRequestDispatcher(StreamServer* pSvr, TCPSocket* pTcpSocket);
  virtual ~StreamRequestDispatcher();
  
  int writeData(const char* buf, int len);

private:

  void dispatchRequest();
  
  virtual void close(); //Close TCPSocket and destroy data
  
  void onTcpSocketEvent(TCPSocketEvent e);
  
  bool getRequest(string* request);
  
  StreamServer* m_pSvr;
  TCPSocket* m_pTcpSocket;
  
  bool m_closed;
};
//END REQUEST DISPATCHER========================================================

//Including handlers here for more convenience
//#include "impl/RpcHandler.h"
//#include "impl/FSHandler.h"
//#include "impl/SimpleHandler.h"

#endif  // _STREAMSERVER_H_
