#define MY_DEBUG_LEVEL 2
#define MBED_BOB2 1
#define USE_SD 0

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "StreamServer.h"

#if USE_SD
#include "SDFileSystem.h"
#endif

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

//LocalFileSystem fs("webfs");
LocalFileSystem local("webfs");
#if USE_SD
SDFileSystem sd(p5, p6, p7, p8, "sd");        // MBED-BoB2
#endif

EthernetNetIf eth;
//#if 0 // Fixed address
//EthernetNetIf eth(
//  IpAddr(192,168,0,101), //IP Address
//  IpAddr(255,255,255,0), //Network Mask
//  IpAddr(192,168,0,1), //Gateway
//  IpAddr(192,168,0,1)  //DNS
//);
//#endif 
HTTPServer svr;
StreamServer stream;
Serial pc(USBTX, USBRX);

int gDebug=MY_DEBUG_LEVEL;
float gWait = 0.005;        // Main loop wait timeout

int main() {
  bool use_sd = false;
  unsigned int cnt = 0;

pc.baud(115200);
  Base::add_rpc_class<DigitalOut>();

  printf("\r\nSetting up...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");
  
#if USE_SD
  // Check if we can use SD card for the web server
  FILE *fp = fopen("/sd/index.htm", "r");
  if (fp == NULL) {
    if (gDebug) printf("DEBUG: No SD card found or no index.htm file - using LocalFilesystem for WebServer.\r\n");
  } else {
    use_sd = true;
    fclose(fp);
    if (gDebug) printf("DEBUG: Found SD card with index.htm file - using SD for WebServer.\r\n");
  }
#endif

  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>(""); //Default handler
  //FIXME: can't use this:    , use_sd ? "/sd/" : "/local/");
  //Example : Access to mbed.htm : http://a.b.c.d/webfs/mbed.htm
  
  svr.bind(80);
  
  printf("\r\nHTTP Listening...\r\n");

//#### STREAM SOCKETS
stream.bind(123);
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      if ((cnt % 4) == 0) {
        char buf[100];
        int len = sprintf(buf, ".tick.%d======================================================================\r\n", cnt);
        stream.sendToAll(buf, len);
        printf("%s - %d clients\r\n", buf, stream.countClients());
//        printf(".tick.%d - %d clients\r\n", cnt, stream.countClients());
      }
      tm.start();
      cnt++;
    }
//    wait(gWait);
  }

  return 0;

}
