
/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#define __LWIP_DEBUG
#define __DEBUG
#include "dbg.h"
#include "mbed.h"
#include <cstdarg>
#include "string.h"

//LocalFileSystem dbgfs("dbgsfs"); 

//static FILE* m_fp = NULL;

static int strpos (const char *haystack, const char *seed) {
  int pos;
  const char *pos_char = haystack;
  const char *seed_char = seed;
  while (*pos_char != 0) {
    while (*pos_char != 0 && *seed_char != 0 && *pos_char == *seed_char) {
      pos_char++;
      seed_char++;
    }
    if (*seed_char == 0) {
      return pos;   // We reached the end of seed and matched.
    }
    pos++;
    pos_char = haystack + pos;
    seed_char = seed;
  }
  return -1;    // not found
}
void DebugStream::debug(const char* format, ...)
{
//  if(!m_fp)
//    m_fp = fopen("/dbgsfs/dbg.txt", "a");
  va_list argp;
  
  va_start(argp, format);
#if 0 // DEBUG_FIXLF
  vprintf(format, argp);
  //vfprintf(m_fp, format, argp);
  va_end(argp);
#else
  int len;
  char buf[512];
  len = vsprintf(buf, format, argp);
  if (buf[len-1] == '\n' && buf[len-2] != '\r') {
    // Fix CR without LF
    buf[len-1] = '\r';
    buf[len]   = '\n';
    buf[len+1] = '\0';
    len++;
  }
  if (len >= (sizeof(buf)/sizeof(buf[0]))) {
    printf("DebugStream::debug() buffer overflow (len=%d).\r\n", len);
  }
  if (WHERECHOP) {
    int pos = strpos(format, WHEREFMT);
    if (pos >= 0) {
      char *from = buf+pos+WHERECHOP;
      char *to   = buf    +WHERESKIP;
      while (*from != 0) {
        *(to++) = *(from++);
      }
      *(to) = 0;
    }
  }
  va_end(argp);
  printf(buf);
#endif
  
 // printf("\r\n"); //Flush
  //local("local");               // Create the local filesystem under the name "local"
  
//  fclose(m_fp);
}

void DebugStream::release()
{
  //fclose(m_fp);
}

/*
int snprintf(char *str, int size, const char *format, ...)
{
  va_list argp;
  
  va_start(argp, format);
  vsprintf(str, format, argp);
  va_end(argp);
  
  return strlen(str);
}
*/

