/* lighting-system-firmware/source/main.cpp */

#include "mbed.h"
#include "led.h"    // Abstracts away the differens between the LED types

// PIR sensor acts as an interrupt - signals us whenever it goes high (or low)
InterruptIn pir(PIR_PIN);   // This pin value comes out mbed_app.json

// Whenever movement is not detected
void pir_fall() {
  setRgbColor(0.0f, 0.0f, 0.0f);
}

// Whenever movement is detected
void pir_rise() {
  // set the color to red
  setRgbColor(1.0f, 0.0f, 0.0f);
}

int main(int, char**) {
  // Blink the LED when the application starts
  setRgbColor(0.0f, 1.0f, 0.0f);
  Thread::wait(500);
  setRgbColor(0.0f, 0.0f, 0.0f);

  // The PIR sensor uses interrupts, no need to poll
  pir.fall(&pir_fall);
  pir.rise(&pir_rise);
}