#include "mbed.h"
#include "TextLCD.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn bp0(p13);
DigitalIn bp1(p12);
DigitalIn bp2(p11);

TextLCD lcd(p14, p19, p24, p23, p22, p21);

DigitalIn fdc(p5);
DigitalIn jack(p7);

AnalogIn pot(p20);
AnalogIn dExt(p15), gExt(p16), gInt(p17), dInt(p18);

PwmOut motG(p25), motD(p26);
DigitalOut dirG(p6), dirD(p8);

Serial pc(USBTX, USBRX);
Serial bt(p28, p27);

void pcRecept(void)
{
    int c = pc.getc();
    bt.putc(c);
}

void btRecept(void)
{
    int c = bt.getc();
    pc.putc(c);
}

int main() {
    pc.baud(9600);
    bt.baud(9600);
    pc.attach(pcRecept);
    bt.attach(btRecept);

    bp0.mode(PullUp);
    bp1.mode(PullUp);
    bp2.mode(PullUp);
    
    motG.period_us(50);
    motG = 0;
    motD = 0;
    dirG = 0;
    dirD = 0;
        
    while(1) {
        led1 = bp1;
        led2 = bp2;
        led3 = bp0;
        lcd.locate(0, 0);
        lcd.printf("%3.1f %3.1f %3.1f %3.1f", gExt.read(), gInt.read(), dInt.read(), dExt.read());
        lcd.locate(0, 1);
        lcd.printf("%3.1f ", pot.read());
        if (jack == 0) lcd.printf("/"); else lcd.printf(" ");
        lcd.printf("J ");
        if (fdc == 0) lcd.printf("/"); else lcd.printf(" ");
        lcd.printf("F");
        if (bp0==0) motG = pot; else motG = 0;
        if (bp1==0) motD = pot; else motD = 0;
        dirG = bp2;
        dirD = bp2;
    }
}
