/* Example file of using SD/MMC Block device Library for MBED-OS
 * Copyright 2017 Roy Krikke
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include "mbed.h"
#include "FATFileSystem.h"
#include "sd_bd_disco.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "stm32746g_discovery_lcd.h"
#include "bitmap.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

DigitalOut led (LED1);

// Instantiate the Block Device for sd card on DISCO-F746NG
SDBlockDeviceDISCOF746NG bd;
FATFileSystem fs ("fs");

void return_error (int ret_val)
{
    char buf[30];
    if (ret_val) {
        sprintf(buf, "Fail %d", ret_val);
        lcd.DisplayStringAt(0, LINE(8), (uint8_t *)buf, CENTER_MODE);
    } else {
        lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"Done", CENTER_MODE);
    }
}

void errno_error(void* ret_val)
{
    char buf[30];
    if (ret_val == NULL) {
        sprintf(buf, "Fail %d", errno);
        lcd.DisplayStringAt(0, LINE(9), (uint8_t *)buf, CENTER_MODE);
    } else {
        lcd.DisplayStringAt(0, LINE(9), (uint8_t *)"Done", CENTER_MODE);
    }
}

int main ()
{
    char buf[100];

    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"TOUCHSCREEN SD DEMO", CENTER_MODE);
    lcd.SetFont(&Font12);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"Start", CENTER_MODE);
    wait(1);

    int error = 0;
    /*
        error = FATFileSystem::format(&bd);
        return_error(error);
    */
    lcd.DisplayStringAt(0, LINE(3), (uint8_t *)"Mounting the filesystem on \"/fs\". ", CENTER_MODE);
    error = fs.mount(&bd);
    return_error(error);

    CBitmap bmp("/fs/minion.bmp");

    sprintf(buf, "Bitmap width: %3d - height: %3d", bmp.GetWidth(), bmp.GetHeight());
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)buf, CENTER_MODE);

//    BSP_LCD_DrawBitmapRAM(150,100,bmp.GetWidth(), bmp.GetHeight(),(uint8_t *)bmp.GetBits());
    while (1) {
        int layer = 0;
        for (int k=0; k<50; k++) {
            uint32_t *p = (uint32_t *)bmp.GetBits();
            lcd.SelectLayer(layer);
            lcd.Clear(0);
            for (int i=bmp.GetHeight()-1; i>=0; i--) {
                if (i+2*k >= lcd.GetYSize()) {
                    p += bmp.GetWidth();
                    continue;
                }
                for (int j=0; j<bmp.GetWidth(); j++) {
                    /*            uint32_t c0 = *p++;
                                uint8_t a = c0>>24;
                                uint8_t r = c0>>16;
                                uint8_t g = c0>>8;
                                uint8_t b = c0;
                                uint32_t c = (a<<24)+(b<<16)+(g<<8)+r;*/
                    uint32_t x = j + 3*k;
                    if (x >= lcd.GetXSize()) break;
                    lcd.DrawPixel(x, i+2*k, *p++);
                }
            }
            /*        lcd.SetLayerVisible(layer, ENABLE);
                    layer = !layer;
                    lcd.SetLayerVisible(layer, DISABLE);*/
            BSP_LCD_SetLayerVisible_NoReload(layer, ENABLE);
            layer = !layer;
            BSP_LCD_SetLayerVisible_NoReload(layer, DISABLE);
            BSP_LCD_Reload(LCD_RELOAD_VERTICAL_BLANKING);
            wait(0.02);
        }
        wait(1);
    }
//    lcd.DrawBitmap(0,0,(uint8_t *)bmp.GetBits());
    /*
        lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"Opening a new file, numbers.txt.", CENTER_MODE);
        FILE* fd = fopen("/fs/numbers.txt", "w");
        errno_error(fd);

        for (int i = 0; i < 20; i++) {
            sprintf(buf, "Writing decimal numbers to a file (%2d/20)", i+1);
            lcd.DisplayStringAt(0, LINE(5), (uint8_t *)buf, CENTER_MODE);
            fprintf(fd, "%d\r\n", i);
        }

        fclose(fd);
        printf(" done.\r\n");
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"File closed", CENTER_MODE);
    */
    /*    fd = fopen("/fs/numbers.txt", "r");
        errno_error(fd);

        printf("Dumping file to screen.\r\n");
        char buff[16] = { 0 };
        while(!feof (fd)) {
            int size = fread(&buff[0], 1, 15, fd);
            fwrite(&buff[0], 1, size, stdout);
        }
        printf("EOF.\r\n");

        printf("Closing file.");
        fclose(fd);
        printf(" done.\r\n");

        printf("Opening root directory.");
        DIR* dir = opendir("/fs/");
        errno_error(fd);

        struct dirent* de;
        printf("Printing all filenames:\r\n");
        while((de = readdir (dir)) != NULL) {
            printf("  %s\r\n", &(de->d_name)[0]);
        }

        printf("Closeing root directory. ");
        error = closedir(dir);
        return_error(error);
        printf("Filesystem Demo complete.\r\n");
    */
    // Blink led with 2 Hz
    while(true) {
        led = !led;
        wait (0.5);
    }
}
