/**
 * @file TCPServer.cpp
 * @brief The TCPServer demo of library WeeESP8266. 
 * @author Wu Pengfei<pengfei.wu@itead.cc> 
 * @date 2015.02
 * 
 * @par Copyright:
 * Copyright (c) 2015 ITEAD Intelligent Systems Co., Ltd. \n\n
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version. \n\n
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "ArduinoAPI.h"
#include "ESP8266.h"

extern void setup(void);
extern void loop(void);

ArduinoSerial esp_uart(p28, p27);
ESP8266 wifi(esp_uart);
Serial pc(USBTX, USBRX);

int main () {
    setup();
    while(1) {
        loop();
    }
}


void setup(void)
{
    printf("setup begin\r\n");
    
    printf("FW Version: %s\r\n", wifi.getVersion().c_str());
      
    if (wifi.setOprToStationSoftAP()) {
        printf("to station + softap ok\r\n");
    } else {
        printf("to station + softap err\r\n");
    }

    if (wifi.joinAP("ITEAD", "12345678")) {
        printf("Join AP success\r\n");
        printf("IP: [%s]\r\n", wifi.getLocalIP().c_str());       
    } else {
        printf("Join AP failure\r\n");
    }
    
    if (wifi.enableMUX()) {
        printf("multiple ok\r\n");
    } else {
        printf("multiple err\r\n");
    }
    
    if (wifi.startTCPServer(8090)) {
        printf("start tcp server ok\r\n");
    } else {
        printf("start tcp server err\r\n");
    }
    
    if (wifi.setTCPServerTimeout(10)) {
        printf("set tcp server timout 10 seconds\r\n");
    } else {
        printf("set tcp server timout err\r\n");
    }
    
    printf("setup end\r\n");
}

void loop(void)
{
    uint8_t buffer[1024] = {0};
    uint8_t mux_id;
    
    uint32_t len = wifi.recv(&mux_id, buffer, sizeof(buffer), 100);
    if (len > 0) {
        printf("Status:[%s]\r\n", wifi.getIPStatus().c_str());
        
        printf("Received from %u:[", mux_id);
        for(uint32_t i = 0; i < len; i++) {
            printf("%c", buffer[i]);
        }
        printf("]\r\n");
        
        if(wifi.send(mux_id, buffer, len)) {
            printf("send back ok\r\n");
        } else {
            printf("send back err\r\n");
        }
        
        if (wifi.releaseTCP(mux_id)) {
            printf("release tcp %u ok\r\n", mux_id);
        } else {
            printf("release tcp %u err\r\n", mux_id);
        }
        
        printf("Status:[%s]\r\n", wifi.getIPStatus().c_str());
    }
}