/**
* MFRC522 example
*/*

 #include "mbed.h"
 #include "MFRC522.h"

 //KL25Z Pins for MFRC522 SPI interface
 #define SPI_MOSI    PTC6
 #define SPI_MISO    PTC7
 #define SPI_SCLK    PTC5
 #define SPI_CS      PTC4
 // KL25Z Pin for MFRC522 reset
 #define MF_RESET    PTC3
 // KL25Z Pins for Debug UART port
 #define UART_RX     PTA1
 #define UART_TX     PTA2

 DigitalOut LedRed   (LED_RED);
 DigitalOut LedGreen (LED_GREEN);

 Serial     DebugUART(UART_TX, UART_RX);
 MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);

 int main(void)  {
   // Set debug UART speed
   DebugUART.baud(115200);

   // Init. RC522 Chip
   RfChip.PCD_Init();

   while (true) {
     LedRed   = 1;
     LedGreen = 1;

     // Look for new cards
     if ( ! RfChip.PICC_IsNewCardPresent())
     {
       wait_ms(500);
       continue;
     }

     LedRed   = 0;

     // Select one of the cards
     if ( ! RfChip.PICC_ReadCardSerial())
     {
       wait_ms(500);
       continue;
     }

     LedRed   = 1;
     LedGreen = 0;

     // Print Card UID
     printf("Card UID: ");
     for (uint8_t i = 0; i < RfChip.uid.size; i++)
     {
       printf(" %X02", RfChip.uid.uidByte[i]);
     }
     printf("\n\r");

     // Print Card type
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
     printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
     wait_ms(1000);
   }
 }

