/* mbed BuschA,   */ 
#include "mbed.h"
#include "UP_SOS.h"
//Initialisiere Ausgangspin und Variable
InterruptIn TasteS1(PA_10); //PullUp auf Board; sonst PA_1

void ISR_SOS (void)   //ISRotine..
        {
              TIM6->CR1=1;                  //CEN=1 Timer start
        }

void ISR_TIM6 (void)
{
    TIM6->SR=0; //UIF =0 (Update Interrupt Flag)
    TIM6->CR1=0;                  //CEN=0 Timer stopp
    UP_SOS_kurz();                //Funktionsaufrufe...
    UP_SOS_lang();
    UP_SOS_kurz();
    TIM6->CR1=1;                  //CEN=1 Timer startet wieder für 5sec
}


void init_TIM6(void)
{
  RCC->APB1ENR |= 0b10000;      //Bit 4 => Takt an Timer geben
  TIM6->PSC=31999;              //Takt 1ms  => 32Mhz / 32000 (0-31999) => 1Khz => 1ms
  TIM6->ARR=5000;               //Zählregister => 5000 => 5000ms
  TIM6->CNT=0;                  //bei 0 beginnen 
  TIM6->SR=0;                   //UIF = 0  => Überlaufflag
  TIM6->DIER=1;                 //UIE = 1 (Update Interrupt Enable)
  HAL_NVIC_EnableIRQ(TIM6_IRQn);//
  NVIC_SetVector(TIM6_IRQn, (uint32_t)&ISR_TIM6);
}

void IR_init (void)
{
    //TasteS1.mode(PullUp);    // Pull-Up auf Hardware (PullDown)
    TasteS1.fall(&ISR_SOS);  //steigende Flanke = rise
    TasteS1.enable_irq();   //IR aktivieren
}
int main()
{
init_TIM6();
IR_init();

    while (true) 
    {
        
            {
                
            }
    }
}


