/* mbed BuschA,   */ 
#include "mbed.h"
#include "UP_SOS.h"
//Initialisiere Ausgangspin und Variable
InterruptIn TasteS1(PA_1); //PullUp auf Board

void init_TIM6(void)
{
  RCC->APB1ENR |= 0b10000;      //Bit 4 => Takt an Timer geben
  TIM6->PSC=31999;              //Takt 1ms  => 32Mhz / 32000 (0-31999) => 1Khz => 1ms
  TIM6->ARR=5000;               //Zählregister => 5000 => 5000ms
  TIM6->CNT=0;                  //bei 0 beginnen 
  TIM6->SR=0;                   //UIF = 0  => Überlaufflag
  TIM6->CR1=1;                  //CEN=1 Timer start
}


int main()
{
init_TIM6();

    while (true) 
    {
        if (TIM6->SR!=0) //Überlauf? => Polling => KEIN Timer-IR
            {
                TIM6->CR1=0;                  //CEN=0 Timer stopp
                TIM6->SR=0;                   //Flag zurücksetzen
                UP_SOS_kurz();                //Funktionsaufrufe...
                UP_SOS_lang();
                UP_SOS_kurz();
                TIM6->CR1=1;                  //CEN=1 Timer startet wieder für 5sec
            }
    }
}


