// By: Jonathan Osei-Owusu, Alex Mussa
// 4180 Final Project

// Goal: ESP8266 static page WEB server to send text queries to Alexa via Mbed and TExt-to-Speech module.
//       WEB server accessible from any network.
//       Also uses FONA chip to allow Alexa text queries via SMS.


#include "mbed.h"
#include "emic2.h"
#include <string.h>
#include <ctype.h>
#include "Adafruit_FONA.h"

/////// ------ Begin FONA Global Region ----- ////////

#define FONA_RST p12
#define FONA_TX p13
#define FONA_RX p14
#define FONA_RI p11

// this is a large buffer for replies
char replybuffer[255];
char smsText[255], smsPhoneNo[11]; ///// By Jonathan: Text to send to Text -> Speech chip & phone # to send to 
int count; // by Jonathan
Serial pcSerial(USBTX, USBRX);
Adafruit_FONA fona(FONA_TX, FONA_RX, FONA_RST, FONA_RI);
void replySMS(char*);

// Turn on a LED when somebody call the FONA
emic2 myTTS(p9, p10);
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);

class FonaEventListener : public Adafruit_FONA::EventListener {
    virtual void onRing() {
        led1 = 1;
    }
    
    virtual void onNoCarrier() {
        led1 = 0; 
    }
};
FonaEventListener fonaEventListener;

// Functions defined after main()
uint8_t readline(char *buff, uint8_t maxbuff, uint16_t timeout = 0);
void printMenu(void);
void flushSerial();
char readBlocking();
uint16_t readnumber();
long map(long x, long in_min, long in_max, long out_min, long out_max);

/////// ------ End FONA Global Region ----- ////////


////// ------- Begin ESP Global Region -------- //////

Serial esp(p28, p27); // tx, rx

// some test values to show on web page
AnalogIn   Ain1(p18);
AnalogIn   Ain2(p19);

/*
char ssid[32] = "hsd";     // enter WiFi router ssid inside the quotes
char pwd [32] = "austin123"; // enter WiFi router password inside the quotes
*/
float temperature, AdcIn, Ht;
float R1=100000, R2=10000; // resistor values to give a 10:1 reduction of measured AnalogIn voltage
char Vcc[10];
char Temp[10];

// things for sending/receiving data over serial
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 4095;
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();

int DataRX;
int update;
int espCount;
char cmdbuff[1024];
char replybuff[4096];
char webdata[4096]; // This may need to be bigger depending on WEB browser used
char webbuff[4096];     // Currently using 1986 characters, Increase this if more web page data added
char timebuf[30];
void SendCMD(),getreply(),ReadWebData(),startserver();
void gettime(),setRTC(),gettemp(),getbattery();
char rx_line[1024];
int port        =80;  // set server port
int SERVtimeout =5;    // set server timeout in seconds in case link breaks.
struct tm t;
// manual set RTC values
int minute      =00;    // 0-59
int hour        =12;    // 2-23
int dayofmonth  =26;    // 1-31
int month       =8;     // 1-12
int year        =15;    // last 2 digits


//// -------- End ESP Global region -------- /////

int main()
{
    myTTS.volume(5);
    myTTS.voice(0);
    
    pcSerial.baud(9600);
    esp.baud(9600);
    wait(1);
    
    ////---------------- Begin FONA init setup Region -------// 
    
    pcSerial.printf("\r\n");
    
    pcSerial.printf("FONA basic test\r\n");
    pcSerial.printf("Initializing....(May take 3 seconds)\r\n");
    
    // See if the FONA is responding
    if (! fona.begin(9600)) {
        pcSerial.printf("Couldn't find FONA\r\n");
        while (1);
    }
    fona.setEventListener(&fonaEventListener);
    pcSerial.printf("FONA is OK\r\n");
    
    // Print SIM card IMEI number.
    char imei[15] = {0}; // MUST use a 16 character buffer for IMEI!
    uint8_t imeiLen = fona.getIMEI(imei);
    if (imeiLen > 0) {
        pcSerial.printf("SIM card IMEI: %s\r\n", imei);
    }
    
    ////----- End FONA init setup region -----////
    
    
    ////----- Begin ESP init setup region ----////
    
    led1 = 0, led2 = 0, led3 = 0, led4 = 0;
    // Setup a serial interrupt function to receive data
    esp.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    esp.attach(&Tx_interrupt, Serial::TxIrq);
    if (time(NULL) < 1420070400) {
        setRTC();
    }
    startserver();
    DataRX=0;
    espCount=0;
    wait(3);
    
    ////----- End ESP init setup region ----////
    
    while(1) {        
        ////---- Begin ESP loop ----////
        if(DataRX==1) {
            ReadWebData();
            esp.attach(&Rx_interrupt, Serial::RxIrq);
        }
        if(update==1) // update time, hit count, and analog levels in the HUZZAH chip
        {
            // get new values
            gettime();
            gettemp();
            getbattery();
            espCount++;
            // send new values
            sprintf(cmdbuff, "espCount,time,analog1,analog2=%d,\"%s\",\"%s\",\"%s\"\r\n",espCount,timebuf,Temp,Vcc); 
            SendCMD();
            getreply();
            update=0;   
        }
        ////---- End ESP loop ----////
        
        ////---- Begin FONA loop ----////
        
        //pcSerial.printf("FONA waiting for SMS...\r\n");
        
        //while (! pcSerial.readable()) {
            //if (fona.readable()) {
          while (fona.readable() && ! pcSerial.readable()) {
                //// Printf that incoming SMS detected
                pcSerial.putc(fona.getc()); 

                    
                // ----------------------------------------------------------------//
                
                // read an SMS + send -> TTS chip
                flushSerial();
                pcSerial.printf("\r\nReading SMS #1\r\n");
                
                // Retrieve SMS sender address/phone number.
                if (! fona.getSMSSender(1, replybuffer, 250)) {
                    pcSerial.printf("Failed!\r\n");
                    break;
                }
                pcSerial.printf("FROM: %s\r\n", replybuffer);
                for (int i = 0; i < 10; i++) { /////// BY JONATHAN to store phone # to respond to
                    smsPhoneNo[i] = replybuffer[i + 2]; // chop off the "+1" from phone # returned by replybuffer
                }
                smsPhoneNo[10] = '\0'; // null terminate.... NECESSARY??
                pcSerial.printf("FROM: %s\r\n", smsPhoneNo);
                
                // Retrieve SMS value.
                uint16_t smslen;
                if (! fona.readSMS(1, replybuffer, 250, &smslen)) { // pass in buffer and max len!
                    pcSerial.printf("Failed!\r\n");
                    break;
                }
                pcSerial.printf("***** SMS #1 (%d) bytes *****\r\n", smslen); 
                pcSerial.printf("%s\r\n", replybuffer);
                pcSerial.printf("*****\r\n");
                
                
                
                //char message[255]; // CHANGED BY JONATHAN. 141 -> 255
                char myString[255];
                
                for (int i = 0; i < 255; i++) {
                    myString[i] = replybuffer[i + 5];   // chop of the "Alexa string"    
                }
         
                strcpy(smsText, "Uh lex uh "); //Pronunciation Correction.
                strcat(smsText, myString);
                pcSerial.printf("DEBUG::%s\r\n", smsText);
                myTTS.speakf("S%s\r", smsText);  // Send text message to the text to speech module.
                
              
                 // ----------------------------------------------------------------//
                 
                 // Send SMS back!
                 replySMS(replybuffer);
                 
                 // ----------------------------------------------------------------//
                
                // delete an SMS after response sent back
                flushSerial();
                pcSerial.printf("\r\nDeleting SMS #1\r\n");
                if (fona.deleteSMS(1)) // delete SMS #1
                    pcSerial.printf("OK!\r\n");
                else 
                    pcSerial.printf("Couldn't delete\r\n");
                
           // } // end if
        } // end inner fona.readable() while
        
        ////---- End FONA loop ----////
        
    } // end outer loop
} // end main


// 
void replySMS(char* inMsg) 
{
    // send an SMS back!
    char message[255];
     
    strcpy(message, "");
    
    flushSerial();
    
    pcSerial.printf("Replying to %s\r\n", smsPhoneNo);
    
    
    if(strstr(inMsg, "how old are you")) { // if reply buffer contains that string
        strcpy(message, "I'm 2 in human years, 14 in dog years, and 25 in cat years. I think AI years are marked in nanoseconds, so that makes me, like, a scrillion!");
    }
    else if(strstr(inMsg, "what is the world population")) {
        strcpy(message, "The population of the world is about 7 Billion 400 Million.");
    }
    else if(strstr(inMsg, "integral of x squared")) {
        strcpy(message, "The integral of x squared is one third x cubed plus a constant.");
    }
    else if(strstr(inMsg, "discrete co sine transform")) {
        strcpy(message, "The discrete cosine transform expresses a finite sequence of data points in terms of a sum of cosine function oscillating at different frequencies.");
    } 
    else {
        strcpy(message, "Sorry, command not recognized.");   
    }
    
    pcSerial.printf("%s\r\n", message);
    if (!fona.sendSMS(smsPhoneNo, message))
        pcSerial.printf("Failed\r\n");
     else 
        pcSerial.printf("Sent!\r\n");
                    
}

// Reads and processes GET and POST web data
void ReadWebData()
{
    wait_ms(200);
    esp.attach(NULL,Serial::RxIrq);
    DataRX=0;
    memset(webdata, '\0', sizeof(webdata));
    strcpy(webdata, rx_buffer);
    memset(rx_buffer, '\0', sizeof(rx_buffer));
    rx_in = 0;
    rx_out = 0;
    // check web data for form information
    if( strstr(webdata, "check=age") != NULL ) { ///////// JONATHAN ::: 'led1v' -> 'age'
        strcpy(smsText, "Uh lex uh, how old are you?");
        led1=!led1;
        myTTS.speakf("S%s\r", smsText);  // Send text message to the text to speech module.
    }
    if( strstr(webdata, "check=population") != NULL ) {
        strcpy(smsText, "Uh lex uh, what is the world population?");
        led2=!led2;
        myTTS.speakf("S%s\r", smsText);
    }
    if( strstr(webdata, "check=integral") != NULL ) {
        strcpy(smsText, "Uh lex uh, what is the integral of x squared?");
        led3=!led3;
        myTTS.speakf("S%s\r", smsText);
    }
    if( strstr(webdata, "check=dct") != NULL ) {
        strcpy(smsText, "Uh lex uh, what is the discrete co sine transform?");
        led4=!led4;
        myTTS.speakf("S%s\r", smsText);
    }
    if( strstr(webdata, "POST") != NULL ) { // set update flag if POST request
        update=1;
    }
    if( strstr(webdata, "GET") != NULL && strstr(webdata, "favicon") == NULL ) { // set update flag for GET request but do not want to update for favicon requests
        update=1;
    }
}
// Starts webserver
void startserver()
{
    gettime();
    gettemp();
    getbattery();
    pcSerial.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"node.restart()\r\n");
    SendCMD();
    wait(2);
    getreply();
    
    pcSerial.printf("\n++++++++++ Starting Server ++++++++++\r\n> ");

    // initial values
    sprintf(cmdbuff, "espCount,time,analog1,analog2=0,\"%s\",\"%s\",\"%s\"\r\n",timebuf,Temp,Vcc);
    SendCMD();
    getreply();
    wait(0.5);

    //create server
    sprintf(cmdbuff, "srv=net.createServer(net.TCP,%d)\r\n",SERVtimeout);
    SendCMD();
    getreply();
    wait(0.5);
    strcpy(cmdbuff,"srv:listen(80,function(conn)\r\n");
    SendCMD();
    getreply();
    wait(0.3);
        strcpy(cmdbuff,"conn:on(\"receive\",function(conn,payload) \r\n");
        SendCMD();
        getreply();
        wait(0.3);
        
        //print data to mbed
        strcpy(cmdbuff,"print(payload)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
       
        //web page data
        strcpy(cmdbuff,"conn:send('<!DOCTYPE html><html><body><h1>Alexa Server</h1>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('Hit count: '..espCount..'')\r\n");
        SendCMD();
        getreply();
        wait(0.2);
        strcpy(cmdbuff,"conn:send('<br>Last hit (based on mbed RTC time): '..time..'<br><hr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<form method=\"POST\"')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"x\"> Data Sent')\r\n");
        SendCMD();
        getreply();
        wait(0.3);

        // end web page data
        strcpy(cmdbuff, "conn:on(\"sent\",function(conn) conn:close() end)\r\n"); // close current connection
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "end)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
    strcpy(cmdbuff, "end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);

    strcpy(cmdbuff, "tmr.alarm(0, 1000, 1, function()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "if wifi.sta.getip() == nil then\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "print(\"Connecting to AP...\\n\")\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "else\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "ip, nm, gw=wifi.sta.getip()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"print(\"IP Address: \",ip)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"tmr.stop(0)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    
    pcSerial.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
}

////------- Begin ESP Helper Functions Region ------////
// ESP Command data send
void SendCMD()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (cmdbuff[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = cmdbuff[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (esp.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
// Send first character to start tx interrupts, if stopped
        esp.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}

// Get Command and ESP status replies
void getreply()
{
    read_line();
    sscanf(rx_line,replybuff);
}
 
// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}
 
 
// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    DataRX=1;
    //led3=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((esp.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = esp.getc();
// Uncomment to Echo to USB serial to watch data flow
        pcSerial.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    //led3=0;
    return;
}
 
 
// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((esp.writeable()) && (tx_in != tx_out)) {
        esp.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    //led2=0;
    return;
}

void gettime()
{
    time_t seconds = time(NULL);
    strftime(timebuf,50,"%H:%M:%S %a %d %b %y", localtime(&seconds));
}

void setRTC()
{
    t.tm_sec = (0);             // 0-59
    t.tm_min = (minute);        // 0-59
    t.tm_hour = (hour);         // 0-23
    t.tm_mday = (dayofmonth);   // 1-31
    t.tm_mon = (month-1);       // 0-11  "0" = Jan, -1 added for Mbed RCT clock format
    t.tm_year = ((year)+100);   // year since 1900,  current DCF year + 100 + 1900 = correct year
    set_time(mktime(&t));       // set RTC clock
}
// Analog in example
void getbattery()
{
    AdcIn=Ain1.read();
    Ht = (AdcIn*3.3); // set the numeric to the exact MCU analog reference voltage for greater accuracy
    sprintf(Vcc,"%2.3f",Ht);
}
// Temperature example
void gettemp()
{
 
    AdcIn=Ain2.read();
    Ht = (AdcIn*3.3); // set the numeric to the exact MCU analog reference voltage for greater accuracy  
    sprintf(Temp,"%2.3f",Ht);
}

////------ End ESP Helper Functions Region ------////

////------ Begin FONA Helper Functions Region ------////

void flushSerial() {
    while (pcSerial.readable()) 
        pcSerial.getc();
}

char readBlocking() {
    while (!pcSerial.readable());
    return pcSerial.getc();
}

uint16_t readnumber() {
    uint16_t x = 0;
    char c;
    while (! isdigit(c = readBlocking())) {
        //pcSerial.putc(c);
    }
    pcSerial.putc(c);
    x = c - '0';
    while (isdigit(c = readBlocking())) {
        pcSerial.putc(c);
        x *= 10;
        x += c - '0';
    }
    return x;
}
  
uint8_t readline(char *buff, uint8_t maxbuff, uint16_t timeout) {
    uint16_t buffidx = 0;
    bool timeoutvalid = true;
    if (timeout == 0) timeoutvalid = false;
    
    while (true) {
        if (buffidx > maxbuff) {
            //pcSerial.printf("SPACE\r\n");
            break;
        }
        
        while(pcSerial.readable()) {
            char c =  pcSerial.getc();
            
            //pcSerial.printf("%02x#%c\r\n", c, c);
            
            if (c == '\r') 
                    continue;
                
            
            if (c == '\r') { /////////////////////////////////////////// CHANGED BY JONATHAN: (0XA -> '\r')
                if (buffidx == 0)   // the first 0x0A is ignored
                    continue;
                
                timeout = 0;         // the second 0x0A is the end of the line
                timeoutvalid = true;
                break;
            }
            buff[buffidx] = c;
            buffidx++;
            
            count++; ///////////////////////// ADED BY JONATHAN
        }
        
        if (timeoutvalid && timeout == 0) {
            //pcSerial.printf("TIMEOUT\r\n");
            break;
        }
        wait_ms(1);
    }
    buff[buffidx] = 0;  // null term
    return buffidx;
}

long map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

////------ End FONA Helper Functions Region ------////

