/*
*******************************************************************************
*                              CERES CONTROLS
*                        PANAMA, REPULIC OF PANAMA
*
*  File          : includes.h
*  Programmer(s) : Rangel Alvarado
*  Language      : ANSI-C
*  Description   : Main file for includes.  One file manage all includes file.
*
*  Note          : Here you could start 
*
*  ----------------------------------------------------------------------------
*  HISTORY
*   DD MM AA
*   09 03 15    Created.
*   09 03 15    Modified.
*   12 03 15    Imported to mbed platform.
*******************************************************************************
*/

/*
*******************************************************************************
*                              CONSTANTS AND MACROS
*******************************************************************************
*/

#define TRUE  1                                  /* TRUE  returns a 1        */
#define FALSE 0                                  /* FALSE returns a 0        */
#define HIGH  1                                  /* HIGH returns a 1         */
#define LOW   0                                  /* LOW returns a 0          */
#define OS_ENTER_CRITICAL() __disable_irq();     /* Disble all interrupts    */
#define OS_EXIT_CRITICAL()  __enable_irq();      /* Enable for critical code */


/*
*******************************************************************************
*                              DATA TYPES
*******************************************************************************
*/  

typedef unsigned char  INT8U;   /* Define an unsigned integer (8 bit)        */
typedef unsigned short INT16U;  /* Define an unsinged short (16 bit)         */
typedef unsigned char  BOOLEAN; /* Try a boolean value (8 bit, char)         */


/*
*******************************************************************************
*                             HEADER FILES 
*******************************************************************************
*/  

#include "mbed.h"                 /* MBED Default libraries                  */
#include "SOMO14D.h"              /* All functions for the SOund MOdule      */
#include "MessageQueue.h"         /* RX FIFO and TX FIFO (TX not fully impl) */ 
#include <stdio.h>                /* Contents ASCII to Integer conversion    */
