/*
*******************************************************************************
*                               CERES CONTROLS
*                         PANAMA, REPULIC OF PANAMA
*
*  File          : SOMO14D.h
*  Programmer(s) : Rangel Alvarado
*  Language      : ANSI-C
*  Description   : SOMO14D is an acronym of SOund MOdule 1 4D SYSTEMS INC.
*                  The file mlist all public functions which can be called on
*                  your application.
*
*  Note          : Dependancies of mbed libraries...
*                  - InterruptIn
*                  - DigitalOut
*
*  ----------------------------------------------------------------------------
*  HISTORY
*   DD MM AA
*   09 03 15    Created.
*   09 03 15    Modified.
*   12 03 15    Import to mbed platform.
*   13 03 15    Moved a function to a private state.
*******************************************************************************
*/


/*
*******************************************************************************
*                         CONSTANTS AND MACROS
*******************************************************************************
*/

#define SOMO_BUSY_PIN          PC_0      /* BUSY signal. Active HIGH output.  */
#define SOMO_DATA_PIN          PC_1      /* Serial DATA input from host MCU   */
#define SOMO_CLK_PIN           PC_2      /* Serial Clock input from host MCU  */
#define SOMO_RESET_PIN         PC_3      /* Master Reset. Active LOW trigger. */
#define SOMO_WAIT_BIT          0.01      /* Wait between bits, base = 1 sec.  */
#define SOMO_WAIT_IDLE         0.05      /* Wait between idle, base = 1 sec.  */


#define SOMO_SONG_CMD_MAX      0x01FF    /* 0x0000 = first; 0x01FF = last     */
#define SOMO_VOL_CMD_OFFSET    0xFFF0    /* 0xFFF0 = Vol 0; 0xFFF7 = Vol 7    */
#define SOMO_PAUSE_CMD_OFFSET  0xFFFE    /* Hold or pause/play command        */
#define SOMO_STOP_CMD_OFFSET   0xFFFF    /* Stop audio command                */
#define SOMO_VOL_UNF           0xFF      /* Volume underflow (app specific)   */
#define SOMO_VOL_MIN           0         /* Volume minimun                    */
#define SOMO_VOL_MAX           7         /* Volume maximum                    */


/*
*******************************************************************************
*                         FUNCTION PROTOTYPES
*******************************************************************************
*/

INT8U SOMO14DisBusy(void);               /* Check if SOMO is doing something */
void  SOMO14DInit(void (*pfunc)(void));  /* Initialize the sound module      */
void  SOMO14DPause(void);                /* Hold the current song            */
void  SOMO14DStop(void);                 /* Stop audio and go to sleep mode  */
void  SOMO14DSetVol(INT8U *SOMO14DVol);  /* Increase/Decrease the volume     */
void  SOMO14DSetAudio(INT16U SOMO14DAudioFileNo); /* Set audio file          */
