/*
*******************************************************************************
*                              HTTP://WWW.CERESCONTROLS.COM
*                              PANAMÁ, REPÚBLICA DE PANAMÁ
*
*  File          : main.cpp
*  Programer(s)  : Rangel Alvarado
*  Language      : C/C++
*  Description   : RGB Led Blinking using GPIO
*
*  Notas         : Using standard mbed classes to start in mbed and blink a RGB
*                  led detailed on the manual below.
*  http://cache.freescale.com/files/32bit/doc/user_guide/FRDMK64FUG.pdf
*
*******************************************************************************
*/

#include "mbed.h"                             // mbed supported libraries

DigitalOut R(PTB22);                          // PTB22 = Red   pin
DigitalOut G(PTE26);                          // PTE26 = Green pin
DigitalOut B(PTB21);                          // PTB21 = Blue  pin

typedef unsigned char INT8U;                  // typedef of unsigned char

typedef union {                               // union for easy access of RGBLed
    INT8U RGB;
    struct {
        INT8U r :1;
        INT8U g :1;
        INT8U b :1;
        INT8U   :1;
        INT8U   :1;
        INT8U   :1;
        INT8U   :1;
        INT8U   :1;
    } Bits;
    struct {
        INT8U RGB :3;
        INT8U     :5;
    } MergedBits;
} RGBLED;

                                               // Main application
int main(void)
{
    char   colors;                             // variable for color
    RGBLED RGBled;                             // structure for led


    RGBled.RGB = 0x00;                         // clean outputs
    while(1) {
        for(colors = 0x00; colors < 0x08; RGBled.RGB = colors++) {
            R = RGBled.Bits.r;                 // set red
            G = RGBled.Bits.g;                 // set green
            B = RGBled.Bits.b;                 // set blue
            wait(0.5);                         // software delay 0.5s
        }
    }
    return 0;                                  // never pass here!!!
}