/*
*******************************************************************************
*                                CERES CONTROLS
*                          PANAMA, REPULIC OF PANAMA
*
*  File          : MessageQueue.h
*  Programmer(s) : Rangel Alvarado
*  Language      : ANSI-C
*  Description   : File that handles serial communications and buffer.
*
*  Note          : Dependancies of mbed libraries...
*                  - Serial
*                  
*
*  ----------------------------------------------------------------------------
*  HISTORY
*   DD MM AA
*   09 03 15    Created.
*   09 03 15    Modified.
*   12 03 15    Import to mbed platform.
*******************************************************************************
*/


/*
*******************************************************************************
*                          CONSTANTS AND MACROS
*******************************************************************************
*/

#define MSG_RX_MAX_CHAR 16            /* Maximum characters of the RX Buffer */
#define MSG_TX_MAX_CHAR 16            /* Maximum characters of the TX Buffer */

#define MSG_TX_PIN      USBTX         /* TX PIN Config                       */
#define MSG_RX_PIN      USBRX         /* RX PIN Config                       */


/*
*******************************************************************************
*                              DATA TYPES
*******************************************************************************
*/

typedef struct msgbuf {
    INT8U   MsgRxBufCtr;              /* Byte Counter, RX Buffer             */
    INT8U   MsgRxBufHd;               /* Insertion Buffer Counter, RX Buffer */
    INT8U   MsgRxBufTl;               /* Extraction Buffer Counter, RX Buffer*/
    INT8U   MsgRxBuf[MSG_RX_MAX_CHAR];/* Buffer size, RX Buffer              */
    INT8U MsgTxBufCtr;                /* Byte Counter, TX Buffer             */
    INT8U MsgTxBufHd;                 /* Insertion Buffer Counter, TX Buffer */
    INT8U MsgTxBufTl;                 /* Extraction Buffer Counter, TX Buffer*/
    INT8U MsgTxBuf[MSG_TX_MAX_CHAR];  /* Buffer size, TX Buffer              */
} MSG_BUF;                            /* Name of buffer                      */

/*
*******************************************************************************
*                           FUNCTION PROTOTYPES
*******************************************************************************
*/

void    MsgRxISRCfg(void (*msgfunc)(void)); /* Configure Serial RxD Irq      */
void    MsgTxISRCfg(void (*msgfunc)(void)); /* Configure Serial TxD Irq      */
INT8U     MsgChkSum(INT8U *pdata, INT8U size); /* Compute checksum from data */
void      MsgBufInit(void);           /* Buffers Tx and Rx Initialized       */
INT8U     MsgGet(void);               /* Gets 1 byte from serial port, RX    */
INT8U     MsgGetChar(void);           /* Gets 1 byte from buffer, Rx         */
void      MsgPutRxChar(INT8U data);   /* Put 1 byte on the buffer, RX        */
BOOLEAN MsgRxBufEmpty(void);          /* Status of buffer Empty, RX          */
void      MsgGetLine(INT8U *pdata);   /* Get a line of the buffer, RX        */
void    MsgRxIntDis(void);            /* Disable IRQ, RX                     */
void    MsgRxIntEn(void (*pfunc)(void)); /* Enable IRQ, Rx                   */
void    MsgRxBufFlush(void);          /* Cleans buffer status, Rx            */
void      MsgPut(INT8U data);         /* Puts 1 byte in serial, TX           */
void    MsgPutChar(INT8U data);       /* Send 1 character to the buffer, TX  */
void      MsgPutLine(INT8U *pdata);   /* Send a string from serial, TX       */
BOOLEAN MsgTxBufFull(void);           /* Buffer state full, TX               */
void    MsgTxIntDis(void);            /* Disable IRQ, Tx                     */
void    MsgTxIntEn(void (*pfunc)(void)); /* Enable IRQ, Tx                   */
INT8U   MsgGetTxChar(void);           /* Print a character on serial ISR, Tx */
