/*
*******************************************************************************
*                              HTTP://WWW.CERESCONTROLS.COM
*                              PANAMÁ, REPÚBLICA DE PANAMÁ
*
*  File          : main.cpp
*  Programer(s)  : Rangel Alvarado
*  Language      : C/C++
*  Description   : Simple SD Card File System Write
*
*  Notes         : Using standard mbed classes to write information data in
*                  the SD Card.
*  http://cache.freescale.com/files/32bit/doc/user_guide/FRDMK64FUG.pdf
*
*******************************************************************************
*/

#include "mbed.h"                          // mbed application libraries
#include "SDFileSystem.h"                  // SD File System functions

#define DAT0 PTE3                          // MOSI
#define CMD  PTE1                          // MISO
#define CLK  PTE2                          // SCLK
#define CD   PTE4                          // CS

SDFileSystem sd(DAT0, CMD, CLK, CD, "sd"); // MOSI, MISO, SCLK, CS
Serial pc(USBTX, USBRX);                   // Virtual COM Port

int main() {
    FILE *File = fopen("/sd/sdfile.txt", "w");   // open file
    if(File == NULL) {                           // check if present
        pc.printf("No SD Card or bad format\n"); // print message
    } else {                                     // otherwise
        pc.printf("Ready to write\n");           // message preparing to write
    }
    fprintf(File, "FRDM-K64F");                  // write data
    fclose(File);                                // close file on SD
}