// ZMotionDetector.h
// Support for the Zilog ePIR Motion Detection Zdots SBC

#ifndef _ZMOTIONDETECTOR_
#define _ZMOTIONDETECTOR_

#ifndef MBED_H
#include "mbed.h"
#endif

class ZMotionDetector
{
public:
    ZMotionDetector( PinName ztx, PinName zrx );
    
    virtual ~ZMotionDetector() {};
    
    bool IsMotionDetected();
    
    void SetAsyncMode( bool on );
    
    void SetExtendedRange( bool on );
    
    void ResetDetector();
    
    void Motion();

protected:
    Serial fMDPort;
};

#endif
