// Motion detector support for the Zilog ePIR Motion Detection ZDots SBC

#include "mbed.h"
#include "ZMotionDetector.h"
#include "HoldInterrupts.h"

//const char NACK = 0x15;
const char ACK = 0x06;

ZMotionDetector::ZMotionDetector( PinName ztx, PinName zrx )
: fMDPort( ztx, zrx )
{}

bool
ZMotionDetector::IsMotionDetected()
{
//    HoldInterrupts noir;
    
    fMDPort.putc('a');  // Read Motion status
    return fMDPort.getc() == 'Y';
}

void
ZMotionDetector::SetExtendedRange( bool on )
{
    HoldInterrupts noir;
    
    fMDPort.putc('E');
    fMDPort.getc(); // Current value
    fMDPort.putc( on ? 'Y' : 'N' );
    if (fMDPort.getc() != ACK)
        printf("Error setting extended motion detector range\r\n");
}
    
void
ZMotionDetector::SetAsyncMode( bool on )
{
    HoldInterrupts noir;
    
    if (! on)
        fMDPort.attach( NULL );
    fMDPort.putc('M');
    fMDPort.getc(); // Gets the current mode setting)
    fMDPort.putc( on ? 'Y' : 'N' );
    if (fMDPort.getc() != ACK)
        printf("Error setting motion detector async mode\r\n");
    else
        if (on) 
            fMDPort.attach( this, &ZMotionDetector::Motion );
}

void
ZMotionDetector::Motion()
{
    printf("Motion!!\r\n");
}
