#ifndef _SYSTEMSTATE_
#define _SYSTEMSTATE_

#ifndef _USERINTERFACE_
#include "UserInterface.h"
#endif

#ifndef MBED_H
#include "mbed.h"
#endif

#include <string>

#define DEFINE_GET_SET_VAR( vtype, name ) \
public:\
 vtype Get ## name() const { return f ## name; };\
 void Set ## name( const vtype& var ) { if (f ## name != var) { f ## name = var; Modified(); } };\
private:\
 vtype f ## name;


class SystemState 
{
public:
  SystemState();
  ~SystemState() {};
  bool LoadState();
  void DumpState();     // Debug
  
  DEFINE_GET_SET_VAR( ESelector, ModeSelector )
  DEFINE_GET_SET_VAR( int,       BrightLevel  )
  DEFINE_GET_SET_VAR( int,       SatColorIndex)
  DEFINE_GET_SET_VAR( int,       PatternIndex )
  DEFINE_GET_SET_VAR( int,       LightSensor  )
  
private:
  Timeout fStateTimer;
  void SaveState();
  void Modified();
};

extern SystemState& gSystemState;

#endif
