// SystemState.cpp - Keeps track of system state, so you can
// power on back where you left off.

#include "SystemState.h"
#include "HoldInterrupts.h"
#include "SDFileSystem.h"

const char * kStateFilename =  "/sd/SYSSTATE.TXT";

static SystemState static_SystemState;
SystemState& gSystemState = static_SystemState;

SystemState::SystemState()
{

    fModeSelector = kWhiteSelector;
    fBrightLevel = 7;
    fSatColorIndex = 0;  // This is an INDEX, not actual color
    fPatternIndex = 0;
    fLightSensor = 1;
    
    LoadState();
}

void SystemState::DumpState()
{
    printf( "ModeSelector: %d\r\n", (int) fModeSelector );
    printf( "BrightLevel: %d\r\n",  (int) fBrightLevel  );
    printf( "SatColorIndex: %d\r\n",(int) fSatColorIndex);
    printf( "PatternIndex: %d\r\n", (int) fPatternIndex );
    printf( "LightSensor: %d\r\n",  (int) fLightSensor );
}

void SystemState::Modified()
{
    fStateTimer.detach();    // Reset any previous timer
    fStateTimer.attach( this, &SystemState::SaveState, 30.0 );
}

void SystemState::SaveState()
{
    HoldInterrupts noint();
    SDFileSystem sdcard( p5, p6, p7, p8, "sd" );

    printf("Saving state...");
    FILE * f = fopen( kStateFilename, "w" );
    if (f)
    {
        fprintf( f, "ModeSelector: %d\n", (int) fModeSelector );
        fprintf( f, "BrightLevel: %d\n",  (int) fBrightLevel  );
        fprintf( f, "SatColorIndex: %d\n",(int) fSatColorIndex);
        fprintf( f, "PatternIndex: %d\n", (int) fPatternIndex );
        fprintf( f, "LightSensor: %d\n", (int) fLightSensor );
        fclose(f);
        printf("saved\r\n");
    }
    else
        printf("failed.\r\n");
}

static int getInt( const char * buffer )
{
    string s(buffer);
    size_t colon = s.find(':');
    if ((colon > 0) && (colon < s.size()))
    {
        int value;
        s.erase( 0, colon + 1 );
        sscanf( s.c_str(), "%d", &value );
        return value;
    }
    else
        printf("ERROR: problem reading integer in state file\r\n" );
    return 0;
}

/*
static string getStr( const char * buffer )
{
    char junk[20];
    char value[20];
    int numRead = sscanf( buffer, "%s : %s", junk, value );
    if (numRead != 2)
        printf("ERROR: problem reading string in state file\n" );
    return string(value);
}
*/

static string GetKeyword( const char * buffer )
{
    string s(buffer);
    size_t colon = s.find(':');
    if ((colon > 0) && (colon < s.size()))
        s.resize( colon );  // Truncate
    else
        printf("ERROR: problem reading keyword in state file\r\n" );
    return s;
}

#define READ_STATE_VALUE( key, reader ) \
    if (GetKeyword( buffer ) == string(#key)) f ## key = reader(buffer);

bool SystemState::LoadState()
{
    HoldInterrupts noint();
    SDFileSystem sdcard( p5, p6, p7, p8, "sd" );
   
    char buffer[200];
    printf("Loading state...");
    
    FILE * f = fopen( kStateFilename, "r" );
    if (f)
    {    
        while (fgets( buffer, sizeof(buffer), f))
        {
            READ_STATE_VALUE( ModeSelector, (ESelector)getInt );
            READ_STATE_VALUE( BrightLevel,  getInt );
            READ_STATE_VALUE( SatColorIndex,getInt );
            READ_STATE_VALUE( PatternIndex, getInt );
            READ_STATE_VALUE( LightSensor,  getInt );
        }
        fclose(f);
        printf("loaded.\r\n");
        return true;
    }
    printf("failed.\r\n");
    return false;
}
