#ifndef _SETTINGSMENU_
#define _SETTINGSMENU_

#ifndef _UIMENU_
#include "UIMenu.h"
#endif

class HomeMenu;
class SettingsMenu;

class DebugMenu : public UIMenu
{
public:
    DebugMenu( CheapLCD * lcd, SettingsMenu * parent );
    virtual ~DebugMenu() {};
    void SetItem( int item, const char * name, int value );

protected:
    virtual void KnobPushed();
    SETUP_KNOBPUSH_CALLBACK( DebugMenu );
        
private:
    SettingsMenu * fParent;
};

class LightSensorMenu : public UIMenu
{
public:
    LightSensorMenu( CheapLCD * lcd, SettingsMenu * parent );
    virtual ~LightSensorMenu() {};
    
protected:
    virtual void KnobPushed();
    SETUP_KNOBPUSH_CALLBACK( LightSensorMenu );
    
private:
    SettingsMenu * fParent;
    int fLightState;
};

class SettingsMenu : public UIMenu
{
public:
    SettingsMenu( CheapLCD * lcd, HomeMenu * parent );
    virtual ~SettingsMenu() {};
    
protected:
    virtual void KnobPushed();
    SETUP_KNOBPUSH_CALLBACK( SettingsMenu );
    
private:
    HomeMenu * fParent;
    LightSensorMenu fLightSensorMenu;
    DebugMenu fDebugMenu;
};


#endif
