//
// Settings menu implementation
//

#include "SettingsMenu.h"
#include "UserInterface.h"
#include "SystemState.h"

/*
class SettingsMenu : public UIMenu
{
public:
    SettingsMenu( CheapLCD * lcd, HomeMenu * parent );
    virtual ~SettingsMenu() {};
    
protected:
    virtual void KnobPushed();
    virtual void AttachButton( PushButton * button )
        { button->attach( this, &SettingsMenu::KnobPushed ); }
    
private:
    HomeMenu * fParent;
    CheapLCD * fLCD;
};
*/

SettingsMenu::SettingsMenu( CheapLCD * lcd, HomeMenu * parent )
: UIMenu( lcd, "Settings" ),
  fParent( parent ), 
  fLightSensorMenu( lcd, this ),
  fDebugMenu( lcd, this )
{
    fLabels.push_back( string( "Light Sensor" ) );
    fLabels.push_back( string( "Motion Sensor" ) );
    fLabels.push_back( string( "Defaults" ) );
    fLabels.push_back( string( "Debug" ) );
    fLabels.push_back( string( "Exit Settings" ) );
}

void SettingsMenu::KnobPushed()
{
    switch( SelectedItem() )
    {
    case 0:
        SwitchTo( &fLightSensorMenu );
        break;
        
    case 3:
        SwitchTo( &fDebugMenu );
        break;
        
    case 4:
        SwitchTo( fParent );
        break;
    }
}

LightSensorMenu::LightSensorMenu( CheapLCD * lcd, SettingsMenu * parent )
: UIMenu( lcd ),
   fParent( parent )
{
    fLabels.push_back( string( "Enable" ) );
    fLabels.push_back( string( "Disable" ) );
    fLabels.push_back( string( "Exit" ) );
    fLightState = gSystemState.GetLightSensor();
    fHeader = string( fLightState ? "Lt Sens On" : "Lt Sens Off" );
}

void LightSensorMenu::KnobPushed()
{
    switch( SelectedItem() )
    {
    case 0:
        fLightState = 1;
        ChangeHeader( "Lt Sens On" );
        break;
        
    case 1:
        fLightState = 0;
        ChangeHeader( "Lt Sens Off" );
        break;
        
    case 2:
        gSystemState.SetLightSensor( fLightState );
        SwitchTo( fParent );
        break;
    }
}
    
DebugMenu::DebugMenu( CheapLCD * lcd, SettingsMenu * parent )
: UIMenu( lcd, "Debug" ), fParent( parent )
{
    for (int i = 0; i < 5; ++i)
        fLabels.push_back( string( "..." ));
}

void DebugMenu::SetItem( int item, const char * name, int value )
{
    char label[20];
    sprintf( label, "%s:%d", name, value );
    ChangeItem( item, label );
}

void DebugMenu::KnobPushed()
{
    // No matter what's selected, just exit
    SwitchTo( fParent );
}
