// SerialConnect.h - Connects two serial ports together.

#ifndef _SERIALCONNECT_
#define _SERIALCONNECT_

#pragma once

#ifndef MBED_H
#include "mbed.h"
#endif

class SerialConnect
{
public:
    // By default, makes "9600 8N1" connections for both ports.
    // Need to add APIs to change the port settings...
    SerialConnect( PinName txA, PinName rxA,
                   PinName txB = USBTX, PinName rxB = USBRX );
    
    virtual ~SerialConnect() {};
    
    // Override these if you want to molest the traffic as it
    // moves from port to port.
    virtual void HandleAtoB();
    virtual void HandleBtoA();
    
protected:
    Serial fPortA;
    Serial fPortB;
};

#endif
