// SerialConnect.cpp - Connect two serial ports together

#include "mbed.h"

#include "SerialConnect.h"

SerialConnect::SerialConnect( PinName txA, PinName rxA,
                              PinName txB, PinName rxB )
: fPortA( txA, rxA ), fPortB( txB, rxB )
{
    fPortA.attach( this, &SerialConnect::HandleAtoB );
    fPortB.attach( this, &SerialConnect::HandleBtoA );
}

void SerialConnect::HandleAtoB()
{
    while (fPortA.readable())
        fPortB.putc(fPortA.getc());
}

void SerialConnect::HandleBtoA()
{
    while (fPortB.readable())
        fPortA.putc( fPortB.getc() );
}

