// Rotary Encoder
// Support for the rotary encoder control,
// typically a knob with quadrature output.

#ifndef _ROTARY_ENCODER_
#define _ROTARY_ENCODER_

#ifndef MBED_H
#include "mbed.h"
#endif

#ifndef AJK_PIN_DETECT_H
#include "PinDetect.h"
#endif

#ifndef AJK_FPOINTER_H
#include "FPointer.h"
#endif

class RotaryEncoder
{
 public:
    RotaryEncoder( PinName a, PinName b, PinMode mode = PullDown );

    void attach( int32_t (*function)(int32_t) = 0) 
        { fCallback.attach( function ); }

    template<typename T> 
    void attach(T* item, int32_t (T::*method)(int32_t)) 
        { fCallback.attach( item, method ); }
        
    void detach() { fCallback = FPointer(); }

 private:
    DigitalIn fPinA;
    PinDetect fPinB;
    
    FPointer fCallback;
    
    void debug( const char *where );
    
    void bRise();

};
#endif
