// Rotary Encoder
// Support for the rotary encoder control

#include "RotaryEncoder.h"

RotaryEncoder::RotaryEncoder( PinName a, PinName b, PinMode mode )
        : fPinA( a ), fPinB( b, mode )
{
    fPinA.mode( mode );
    fPinB.setSampleFrequency( 3000 );

    fPinB.attach_asserted( this, &RotaryEncoder::bRise );
}

void RotaryEncoder::debug( const char * where )
{
//    printf("%s: as: %d, bs: %d: aCh: %c, bCh: %c\r\n",
//           where, aState, bState, aChanged ? 'T' : 'F', bChanged ? 'T' : 'F' );
}


void RotaryEncoder::bRise() 
{
    // The status of the A channel on the B channel's rising edge
    // determines which way the shaft is turning.
    if (fPinA.read())
        fCallback.call( 1 );
    else
        fCallback.call( -1 );
}
