//
// RGBLED - Control the RGB LED on the Sparkfun display breakout board
///

#ifndef __RGBLED__
#define __RGBLED__

const float kLEDPWMTable[8] = { 0, 0.01, 0.02, 0.046, 0.1, 0.215, 0.464, 1.0 };

class RGBLED
{
public:
    RGBLED( PinName r, PinName g, PinName b )
        : fRedPWM( r ), fGrnPWM( g ), fBluPWM( b )
    {
        fRedPWM = 1.0;
        fGrnPWM = 1.0;
        fBluPWM = 1.0;
        fRGBValue = 0;
    }
    
    // We use the same "777" RGB values the CuriLights use
    void Set( int rgb )
    {
        if (rgb == fRGBValue)
            return;         // No change
            
        fRGBValue = rgb;
        
        int red = rgb / 100;
        int grn = rgb % 100 / 10;
        int blu = rgb % 10;
                
        fRedPWM = 1.0 - kLEDPWMTable[red];
        fGrnPWM = 1.0 - kLEDPWMTable[grn];
        fBluPWM = 1.0 - kLEDPWMTable[blu];
        
//        printf("RGB: %d, %f %f %f\r\n", rgb, 1.0 - kLEDPWMTable[red], 1.0 - kLEDPWMTable[grn], 1.0 - kLEDPWMTable[blu] );
    }
    
private:
    PwmOut fRedPWM, fGrnPWM, fBluPWM;
    int fRGBValue;
};

// Defined in main for now.
extern RGBLED gDebugLED;

#endif

