// Wrapper function for PinDetect providing 
// simple "pushbutton" functionality

#ifndef _PUSHBUTTON_
#define _PUSHBUTTON_

#ifndef MBED_H
#include "mbed.h"
#endif

class PushButton
{
public:
    PushButton( PinName pin, const char * name = NULL ) : fPin( pin )
    {
        if (name && strlen(name) < sizeof(fName))
            strcpy( fName, name );
        else
            strcpy( fName, "UNKNOWN" );
        fPin.setSampleFrequency( 3000 );
        fPin.mode( PullUp );
        fPin.attach_deasserted( this, &PushButton::SwitchHit );
    }
    
    template<typename T>
    void attach(T* tptr, void (T::*mptr)(void))
    {
        if((mptr != NULL) && (tptr != NULL))
            fPin.attach_deasserted( tptr, mptr );
    }
    
    void detach() { fPin.detach(); }

    void SwitchHit()
    {
        printf("Pushbutton %s is hit!\n\r", fName);
    }

private:
    PinDetect fPin;
    char fName[20];    
};

#endif
