//
// Interface to the CuriLights
//

#include "LightString.h"

#include "HoldInterrupts.h"

#include "RGBLED.h"

LightString::LightString( PinName pin, int numLights )
 : fLightsPort( pin, NC ), fUSBPort( NC, USBRX ), fSnoop( numLights )
{
    fNumLights = numLights;
    fBufferInPos = 0;
    fBufferOutPos = 0;
    // Attaches the USB port to the light port, so
    // data is passed straight through from the host to the lights.
    fUSBPort.attach( this, &LightString::HandleIncomingData );
//    fLightsPort.attach( this, &LightString::HandleOutgoingData );
}

void LightString::HandleIncomingData()
{
    while (fUSBPort.readable())
    {
        fBuffer[fBufferInPos] = fUSBPort.getc();
        fBufferInPos++;
        if (fBufferInPos >= sizeof( fBuffer ))
            fBufferInPos = 0;
        if (fBufferInPos == fBufferOutPos)
            printf("Buffer overflow\r\n");
    }
}

void LightString::HandleOutgoingData()
{
    gDebugLED.Set( 700 );
    while ((fBufferOutPos != fBufferInPos) &&  fLightsPort.writeable())
    {
        fLightsPort.putc( fBuffer[fBufferOutPos++] );
        if (fBufferOutPos >= sizeof( fBuffer ))
            fBufferOutPos = 0;
    }
    gDebugLED.Set( (fBufferOutPos == fBufferInPos) ? 0 : 70 );
}

void LightString::sendCommand1( uint8_t ch )
{
    HoldInterrupts noint();
    
    fLightsPort.putc( ch );
}

void LightString::sendCommand2( uint8_t ch1,  uint8_t ch2 )
{
    HoldInterrupts noint();
    fLightsPort.putc( ch1 );
    fLightsPort.putc( ch2 );
}

void LightString::sendCommand3( uint8_t ch1,  uint8_t ch2, uint8_t ch3 )
{
    HoldInterrupts noint();
    fLightsPort.putc( ch1 );
    fLightsPort.putc( ch2 );
    fLightsPort.putc( ch3 );
}

void LightString::InitLights( int numLights )
{
    if (numLights)
        fNumLights = numLights;

    printf("Init called\n\r");
    sendCommand2( 'I', 0 );
    sendCommand2( 'N', fNumLights );
}

void LightString::SetOneColor( int color, uint8_t id )
{
    uint8_t redBit, c;
    
    c = colorByte( color, redBit );
    
    sendCommand3( 'C', id | redBit, c );
}

void LightString::SetAllLights( int color )
{
    int i;
    for (i = 0; i < fNumLights; ++i)
        SetOneColor( color, i );
}

void LightString::SetColors( const vector<int>& colorList )
{
    int num = fNumLights < colorList.size() ? fNumLights : colorList.size();
    
    for (int i = 0; i < num; ++i)
        SetOneColor( colorList[i], i );
}