//
// LightSnoop.h - Listen to a serial stream, and determine light
// colors and settings from it.
//

#ifndef __LIGHTSNOOP__
#define __LIGHTSNOOP__

#ifndef MBED_H
#include "mbed.h"
#endif

#include <vector>

class LightString;

typedef enum { kAwaitCommand, kAwaitID, kAwaitValue } ESnoopState;

const int kBufferMax = 600;

class LightSnoop
{
public:
    LightSnoop( int numLights );
    ~LightSnoop() {}
    
    void SaveSnoop();
    void Listen( const uint8_t ch );
    
    bool IsActive();
    
private:
    void Process( const uint8_t ch );

    vector<uint16_t> fLightValues;
    ESnoopState fSnoopState;
    uint8_t fCommand;
    uint8_t fID;
    uint8_t fBuffer[kBufferMax];
    int fBufferIndex, fLastBufferIndex;
};

#endif
