//
// LightSnoop.cpp - Listen to a serial stream, and determine light
// colors and settings from it.
//

#include "HoldInterrupts.h"
#include "LightString.h"
#include "LightSnoop.h"
#include "SystemState.h"

#include "SDFileSystem.h"

LightSnoop::LightSnoop( int numLights )
 : fLightValues( numLights ), 
   fSnoopState( kAwaitCommand ),
   fCommand(' '),
   fID( 0 ),
   fBufferIndex( 0 ),
   fLastBufferIndex( 0 )
{
}

bool LightSnoop::IsActive() 
{
    bool active = fBufferIndex != fLastBufferIndex;
    fLastBufferIndex = fBufferIndex;
    return active;
}

void LightSnoop::SaveSnoop()
{
    HoldInterrupts noint();
    SDFileSystem sdcard( p5, p6, p7, p8, "sd" );
    int i;
    
    for (i = 0; i < fBufferIndex; ++i)
        Process(fBuffer[i]);
    fBufferIndex = 0;
    fLastBufferIndex = 0;

    FILE * f = fopen( "/sd/_WEBPAGE.CRI", "w" );

    if (f)
    {
        int i;
        for (i = 0; i < fLightValues.size(); ++i)
            fprintf( f, "%d\r\n", fLightValues[i] );
        fclose(f);
        printf("Updated /sd/_WEBPAGE.CRI\r\n");
        gSystemState.SetPatternIndex( 0 );
        gSystemState.SetModeSelector( kPatternSelector );
    }
    else
        printf("Unable to open /sd/_WEBPAGE.CRI\r\n");
}

void LightSnoop::Listen( uint8_t ch )
{
    if (fBufferIndex >= kBufferMax)
        fBufferIndex = 0;
    fBuffer[fBufferIndex++] = ch;
}

// Convert the nine bit binary RGB value to the 
// "BCD" three digit RGB value
static uint16_t RGB_value( int value )
{
    return ((value >> 6) * 100) 
            + (((value >> 3) & 7) * 10)
            + (value & 7);
}

void LightSnoop::Process( const uint8_t ch )
{
    switch (fSnoopState)
    {
    case kAwaitCommand:
    {
        fCommand = ch;
        switch (ch)
        {
        case 'C':   fSnoopState = kAwaitID; break;      // Set color

        case 'I':                                       // Init string
        case 'N':                                       // Set # of lights
        case 'f':
        case 'F':
        case 'D':   fSnoopState = kAwaitValue; break;
 
        case 'S':
        case 's':
        default:    fSnoopState = kAwaitCommand; break;
        }
    }
    
    case kAwaitValue:
    {
        switch (fCommand)
        {
        case 'C':
            if ((fID & 0x7F) < fLightValues.size())
            {
                fLightValues[fID & 0x7F] = RGB_value( ((fID & 0x80) < 1) | ch );
//                Modified();
            }
            else
                printf("Bad light ID: %d\n", (int) (fID & 0x7F));
            break;
            
        case 'I':   break;  // Could set the lights to the init pattern here...
        case 'N':
            fLightValues.resize( ch );
            break;
        }
        fSnoopState = kAwaitCommand;    // reset state machine
    }
   
    case kAwaitID:
    {
        switch (fCommand)
        {
        case 'C':
            fID = ch;
            fSnoopState = kAwaitValue;
            break;
        default:
            printf("Bad state\n");
            fSnoopState = kAwaitCommand;
            break;
        }
    }
    }
}

    