// This code was scaffolding used to test the hardware design.
// It's deprecated, and here for reference only.

#ifdef notdef

void lcdnumber( CheapLCD * lcd, int y, int32_t value )
{
    HoldInterrupts noIR;
    leds[0] = 0;
    leds[1] = 0;
    lcd->clear( BLACK, (byte)10, (byte)(y-2), (byte) 80, (byte)(y+12) );
    lcd->draw_number( WHITE, BLACK, (byte)10, (byte)y, value );
}


class KnobTest
{
public:
    KnobTest( CheapLCD * lcd, 
              RotaryEncoder * knob, 
              LightString * lights ) : fLCDLED( p22, p23, p24 )
    {
        fLCD = lcd;
        fKnob = knob;
        fKnobValue = 0;
        fLights = lights;
        
        fKnob->attach( this, &KnobTest::knobMoved );
    }
    
    int32_t knobMoved( int32_t step )
    {
        const int lcdledValues[] = { 0, 700, 70, 7, 111, 222, 333, 444, 555, 666, 777 };
        fKnobValue += step;
        lcdnumber( fLCD, 50, fKnobValue );
        
        if ((fKnobValue >= 0)&& (fKnobValue <= 10))
            fLCDLED.Set( lcdledValues[fKnobValue] );
            
        switch (fKnobValue)
        {
        case -2: fLights->InitLights(); break;
        case 0: fLights->Off();     break;
        case 1: fLights->Red();     break;
        case 2: fLights->Green();   break;
        case 3: fLights->Blue();    break;
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9: fLights->SetAllLights( (fKnobValue-2) * 111 ); break;
        default :;
        }

        fLCD->fade_backlight(fKnobValue != 0);
        return 0;
    }

private:
    LCDLED fLCDLED;
    CheapLCD * fLCD;
    RotaryEncoder * fKnob;
    int32_t fKnobValue;
    LightString * fLights;
};

#endif
