// Simple class to disable interrupts in a C++ code block
// Does the right thing when nested calls are made.

#include "HoldInterrupts.h"

static int gHoldInterruptLevel = 0;

HoldInterrupts::HoldInterrupts() 
{
    if (gHoldInterruptLevel == 0)
        __disable_irq();
    gHoldInterruptLevel++;
}

HoldInterrupts::~HoldInterrupts() 
{
    gHoldInterruptLevel--; 
    if (gHoldInterruptLevel == 0)
        __enable_irq();
}
