#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include <string>


EthernetInterface   eth;
TCPSocketConnection server;
NTPClient           ntp;
DigitalOut          led1(LED1);
DigitalOut          led2(LED2);
time_t              rtcTime;
char                tStr[32];
        

int main()
{
    
    printf("Setting up ethernet interface...\r\n");
    if (eth.init() == 0 ) { //Use DHCP
        printf("Ethernet setup OK\r\n");
    } else {
        printf("Error: cannot set ethernet interface\r\n");
        return 1;
    }

    printf("Trying to connect...\r\n");
    wait(0.5);
    if ( eth.connect(30000) == 0 ) {
        printf("IP Address is %s\r\n", eth.getIPAddress());
    } else {
        printf("Error: cannot set ethernet interface\r\n");
        return 1;
    }

    printf("Trying to update time...\r\n");    
    if (ntp.setTime("0.fr.pool.ntp.org") == 0) { //set RTC time
        printf("Set time successfully\r\n");
        wait(1);
        rtcTime = time(NULL); //read the time
        printf("Current time is: %s\r\n", ctime(&rtcTime));        
    } else {
        printf("Error: Cannot set time\r\n");
    }

    printf("Disconnecting...\r\n");    
    eth.disconnect();
    wait(1);
    printf("Ethernet disconnected\r\n");    

    while(1) {                    
        rtcTime = time(NULL); //read the time
        strftime(tStr, 32, "%X\n", localtime(&rtcTime));
        printf("Time as a custom formatted string = %s\r\n", tStr);                
        wait(1);
    }
}