#include "mbed.h"
#include "TMP006.h"
 
#define Address 0x80 

// for dust sensor
DigitalOut myled(LED1);
DigitalOut ledPower(D8);
AnalogIn analog_value(p15);

int samplingTime = 280;//280 microseconds
int deltaTime = 40;//40 us to give total pulse width of 0.32ms
int sleepTime = 9680;//LED off for 9680 us to take 1 measurement per second
 
float dustDensityCN = 0,dustDensitySharp = 0, voMeasured=0, voCalc=0;

// end dust sensor

TMP006 sensor(p9, p10, Address); 
 
int main()
{
  while(1) {
    //printf("ObjTemp: %f \r \n", sensor.readObjTempC(Address));
    //printf("RawDieTem: %f \r \n", sensor.readRawDieTemperature(Address));
    printf("DieTemp: %f \r \n", sensor.readDieTempC(Address));
    
    // dust sensor stuff starts from here
    myled = !myled;
    ledPower=0; // power on the LED. Pull-down to activate
    wait_us(samplingTime);
    voMeasured = analog_value.read(); // Converts and read the analog input value  
    wait_us(deltaTime);
    ledPower=1; // turn the LED off. Pull up to turn off
    wait_us(sleepTime);
 
    voCalc = voMeasured*5.0;//Map 0:1 measured range to 0:3.3V
  
  // Original equation taken from Sharp data sheet measured in mg/m3
  // Sharp don't give you a best fit line, so you have to guess
    dustDensitySharp = 0.5/2.8 * (float(voCalc) - 0.7);
 
  // Eqaution calibrated by Chris Nafis (c) 2012
  // see http://www.howmuchsnow.com/arduino/airquality/
  // measured in parts per 0.01 cf
  // [I did not get meaningful values on my sensor with Chris' formula
  // For me the Sharp graph works just fine. So make your own tests]
     //dustDensityCN = (float(voCalc) - 0.0356)*1.2;
     
    printf("Measurment value: %1.3f", voMeasured);
    printf("Voltage calculated: %1.3f", voCalc);
    printf("Dust Density [mg/m3]: %f", dustDensitySharp);
     // printf(" - C. Nafis' Dust Density [pp.01cf](x10^4): %f\n", dustDensityCN,"\n");
     
    wait(1.0);
  }
}