#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0); // RS, E, D4-D7
Serial gy25(PA_9, PA_10, 115200);
DigitalOut rw(PA_8); // RW

int g[3];
char rxC[8];

void rxIRQ(){
    rxC[0] = gy25.getc();
    if (rxC[0] == 170) {
        for (int i = 1; i < 8; i++) {
            rxC[i] = gy25.getc();
        }
        if (rxC[7] == 85) {
            for (int i = 0, j =1; i < 3; i++, j+=2) {
                g[i] = (rxC[j]<<8 | rxC[j+1])/100;
                if (g[i] > 475)
                    g[i] = g[i] - 476 + 180;
            }
        }
    }
}

int main()
{
    gy25.format(8,SerialBase::None,1);
    lcd.cls();
    lcd.printf("LCD work");
    wait(1);
    gy25.attach(rxIRQ, RawSerial::RxIrq);
    while(1) {
        lcd.locate(0,1);
        lcd.printf("%d,%d,%d",g[0],g[1],g[2]);
        wait(0.4);
        lcd.cls();
    }
}