#include "IMU6050.h"

IMU6050::IMU6050(PinName sda_pin, PinName scl_pin, Serial* out, Timer* time){
    usb = out;
    t = time;
    //imu = new BNO055(sda_pin, scl_pin);
    
    accelD = accelData;
    gyroD = gyroData;
}

void IMU6050::setup() {
    
    
    
    //timer
    t->start();
}

//Get the x component of the angular acceleration from IMU. Stores the component
//in a float array
//Returns a double, the value of the x-acceleration (m/s^2)
double IMU6050::accel_x() {  
    imu -> getAccelero(accelD); //Change the values in accelerationArray
    return (double)accelData[0];
}

//Get the y component of the angular acceleration from IMU. Stores the component
//in a float array
//Returns a double, the value of the y-acceleration (m/s^2)
double IMU6050::accel_y() {
    imu -> getAccelero(accelD); //Change the values in accelerationArray
    return (double)accelData[1];   
}

//Get the z component of the angular acceleration from IMU. Stores the component
//in a float array
//Returns a double, the value of the z-acceleration (m/s^2)
double IMU6050::accel_z() {
    imu -> getAccelero(accelD); //Change the values in accelerationArray
    return (double)accelData[2];
}

//Get the x component of the angular velocity from IMU's gyroscope. Stores the 
//component in a float array
//Returns a double, the value of the x-angular velocity (rad/s)
double IMU6050::gyro_x() {
    imu -> getGyro(gyroD); //Change the values in gyroArray
    return (double)gyroData[0];
    
}

//Get the y component of the angular velocity from IMU's gyroscope. Stores the 
//component in a float array
//Returns a double, the value of the y-angular velocity (rad/s)
double IMU6050::gyro_y() {
    imu -> getGyro(gyroD); //Change the values in gyroArray
    return (double)gyroData[1];
    
}

//Get the z component of the angular velocity from IMU's gyroscope. Stores the 
//component in a float array
//Returns a double, the value of the z-angular velocity (rad/s)
double IMU6050::gyro_z() {
    imu -> getGyro(gyroD); //Change the values in gyroArray
    return (double)gyroData[2];
}

//Get the yaw, or the angle turned at a certain time interval
//Return double, the angle or yaw, (degree)

/*
double IMU6050::yaw() {
    
    imu -> computeAngle();
    return
}

double IMU6050::pitch() {
    
}

double IMU6050::roll() {
    
}

*/