/*******************************************
Motor de Passo
*******************************************/

#include "mbed.h"

Serial pc(USBTX, USBRX);

// variáveis
int estado = 0;
float tempo;
char ligado = 'c';
char desligado = 'd';
char hor = 'h';
char antihor = 't';

// motor de passo
DigitalOut EN_A(D2);
DigitalOut IN1_A(D5);
DigitalOut IN2_A(D4);
DigitalOut EN_B(A4);
DigitalOut IN1_B(A0);
DigitalOut IN2_B(A1);

// entradas
InterruptIn ena_all(D11);
InterruptIn enable(PB_6);
DigitalIn dir(D9);
AnalogIn POT(A5);

// debouncing
Timer debounce;


void muda_en(){
    if (debounce.read_ms()>200){
        estado=!estado;
    }
    debounce.reset();
}


void muda_all(){
    //pc.printf("%c", desligar);
    estado = 0;
    debounce.reset();
}

int main(){    
    enable.rise(&muda_en);
    ena_all.rise(&muda_all);
    debounce.start();
    pc.baud(115200);
    
    // configurações iniciais
    EN_A = 0; 
    EN_B = 0; 
    IN1_A = 0;
    IN2_A = 0;
    IN1_A = 0;
    IN1_B = 0;

    while(1) {
        
        if (estado == 1){
            tempo = 0.002+(0.050*POT.read());
            //pc.printf("%c", ligado);
        
            //SENTIDO HORÁRIO     
            if (dir.read() == 0){
                //pc.printf("%c", hor);
        
                // passo 0
                EN_A = 1;
                IN1_A = 1;
                IN2_A = 0;
                EN_B = 0;
                IN1_B = 1;
                IN2_B = 0;
                wait(tempo);
                
                // passo 1
                EN_A = 0;
                IN1_A = 0;
                IN2_A = 1;
                EN_B = 1;
                IN1_B = 1;
                IN2_B = 0;
                wait(tempo);
       
                // passo 2
                EN_A = 1;
                IN1_A = 0;
                IN2_A = 1;
                EN_B = 0;
                IN1_B = 0;
                IN2_B = 1;
                wait(tempo);
                
                // passo 3
                EN_A = 0;
                IN1_A = 1;
                IN2_A = 0;
                EN_B = 1;
                IN1_B = 0;
                IN2_B = 1;
                wait(tempo);
            }
            
            //SENTIDO ANTI-HORÁRIO
            else if (dir.read() == 1){ 
                //pc.printf("%c", antihor);
            
                // passo 0
                EN_A = 1;
                IN1_A = 1;
                IN2_A = 0;
                EN_B = 0;
                IN1_B = 1;
                IN2_B = 0;
                wait(tempo);
                
                // passo 1 ("passo 3")
                EN_A = 0;
                IN1_A = 1;
                IN2_A = 0;
                EN_B = 1;
                IN1_B = 0;
                IN2_B = 1;
                wait(tempo);
                
                // passo 2
                EN_A = 1;
                IN1_A = 0;
                IN2_A = 1;
                EN_B = 0;
                IN1_B = 0;
                IN2_B = 1;
                wait(tempo);
               
                // passo 3 ("passo 1")
                EN_A = 0;
                IN1_A = 0;
                IN2_A = 1;
                EN_B = 1;
                IN1_B = 1;
                IN2_B = 0;
                wait(tempo);
             }
        }
        
        else{
            //pc.printf("%c", desligado);
            
            EN_A = 0;
            EN_B = 0;
            IN1_A = 0;
            IN2_A = 0;
            IN1_A = 0;
            IN1_B = 0;
        }
    }
}