#include "PlayerChar.h"
;

static int detectiveStill[] = {
    0,0,1,1,1,1,0,0,
    0,0,1,1,1,1,0,0,
    0,0,1,1,1,1,0,0,
    0,1,1,1,1,1,1,0,
    0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,
    1,1,1,1,1,1,1,1,
    1,0,1,1,1,1,0,1,
    1,0,1,1,1,1,0,1,
    0,0,1,1,1,1,0,0,
    0,0,0,1,1,0,0,0,
    0,0,1,1,1,1,0,0,
    0,0,1,1,1,1,0,0,
    0,0,1,0,0,1,0,0,
    0,0,1,0,0,1,0,0
};

// Instantiate the Bitmap object using the data above
Bitmap detective1(detectiveStill, 16, 8); // Specify rows and columns in sprite

PlayerChar::PlayerChar()
{
    _x = 10;
}

/** Update
*
*   Prints the speech at the start of the game.
*   @param lcd - a reference to the instance of N5110 screen
*   @param pad - a reference to the instance of the gampad library
*/
void PlayerChar::update(N5110 &lcd, Gamepad &pad)
{
    //printf("PlayerChars::update");
    float _d = pad.get_direction();
    //printf("Direction from joystick: %I", _d);

    // update x value depending on direction of movement of joystick
    // West is decrement as origin is at the top-left so decreasing moves left
    if (_d == W) {
        _x = _x - 3;
    } else if (_d == E) {
        _x = _x + 3;
    }
    
    //printf("_x value: %I", _x);

    // check the x origin to ensure that the character doesn't go off screen
    if (_x < 2) {
        _x = 2; //if attempts to move left place at edge of screen
    } else if (_x > 76) {
        _x = 76; //if attempts to move right place at edge of screen
    }
    
    //printf(_x value after limits: %I", _x);
    
    detective1.render(lcd, _x, 30);
}

/** Get Detective X Positon
*
*   Returns the x value of the player character.
*/
int PlayerChar::getdex()
{
    //printf("OtherChars::detdex");
    return _x;
    //printf("X value of player character in PlayerChar class: %I");
}