#include "mbed.h"
#include "TextLCD.h"
#include "Keypad.h"
TextLCD lcd(PTE24, PTE25, PTD1, PTD3, PTD2, PTD0, TextLCD::LCD16x2); // rs, e, d4-d7
Keypad kpad(PTA2, PTB23, PTA1, PTB9, PTC4, PTC12, PTC3, PTC2);
DigitalIn borrador(PTC17);
DigitalOut led(PTC16);
int main() {
    char key, memoria = '.';
    int released = 1, contador = 0;
    led = 0;
    while(1){
        if(borrador){ //Testear la dualidad del botón borrador con el ejercicio 3.
            lcd.cls();
            led = 0;
            contador = 0;
        }
        else{
            key = kpad.ReadKey();                   //read the current key pressed

        if(key == '\0')
            released = 1;                       //set the flag when all keys are released
           
        if((key != '\0') && (released == 1)) {  //if a key is pressed AND previous key was release
            lcd.cls();
            switch(key){
                case '0': lcd.printf("00000000 ");
                break;
                case '1': lcd.printf("00000001 ");
                break;
                case '2': lcd.printf("00000010 ");
                break;
                case '3': lcd.printf("00000011 ");
                break;
                case '4': lcd.printf("00000100 ");
                break;
                case '5': lcd.printf("00000101 ");
                break;
                case '6': lcd.printf("00000110 ");
                break;
                case '7': lcd.printf("00000111 ");
                break;
                case '8': lcd.printf("00001000 ");
                break;
                case '9': lcd.printf("00001001 ");
                break;
                case 'A': lcd.printf("00001010 ");
                break;
                case 'B': lcd.printf("00001011 ");
                break;
                case 'C': lcd.printf("00001100 ");
                break;
                case 'D': lcd.printf("00001101 ");
                break;
                default: lcd.printf("%c", key);
            }
            
            if(memoria == key)
                contador = contador + 1;
            else
                contador = 0;
            
            if(contador > 0){
                lcd.cls();
                lcd.printf("\n%c = %d", key, contador);
            }
            
            if(contador == 10){
                led = 1;
            }
            
            memoria = key;
            released = 0;                       //clear the flag to indicate that key is still pressed
        }
        }
    }
}