
#include "cell_ctrl.h"

//These are functions to connect the modem to a port, and to reset the modem.

void cell_ctrl_init(Serial* io, Serial pc, char* buffer){
     // Enable echo
    io->printf("ATE1\r");
    collectResponseString(io, buffer, BUFFER_SIZE, TIMEOUT_MS, 0);
    pc.printf("%s", buffer);
    
    // Disable the forwarding of +++ to the actual data connection
    io->printf("AT#SKIPESC=1\r");
    collectResponseString(io, buffer, BUFFER_SIZE, TIMEOUT_MS, 0);
    pc.printf("%s", buffer);
    
    // Flow control (none)
    //io->printf("AT+IFC=2,2\r");
    io->printf("AT+IFC=0,0\r");
    collectResponseString(io, buffer, BUFFER_SIZE, TIMEOUT_MS, 0);
    pc.printf("%s", buffer);
    
    io->printf("AT+CSQ\r");
    collectResponseString(io, buffer, BUFFER_SIZE, TIMEOUT_MS, 0);
    pc.printf("%s", buffer);
    
    io->printf("AT+CDV*22899\r");
    collectResponseString(io, buffer, BUFFER_SIZE, TIMEOUT_MS, 0);
    pc.printf("%s", buffer);
    
    // Config socket
    io->printf("AT#SCFG=1,1,%i,%i,%i,1\r", 
        PACKET_SIZE, 
        int(INACTIVITY_TIMEOUT), 
        int(CONNECTION_TIMEOUT));
    collectResponseString(io, buffer, BUFFER_SIZE, TIMEOUT_MS, 0);
    pc.printf("%s", buffer);

    // Set context (ppp?)
    io->printf("AT#SGACT=1,1\r");
    collectResponseString(io, buffer, BUFFER_SIZE, 30000, 0);
    pc.printf("%s", buffer);
    
    // Connect to TCP server
    io->printf("AT#SD=1,0,%i,\"%s\",0,1,0\r", PORT, ADDRESS);
    collectResponseString(io, buffer, BUFFER_SIZE, 30000, '\n');
    pc.printf("%s", buffer);
    
    pc.printf("Entering message loop. Now in data mode.\r\n");
    
}

void cell_ctrl_rst(Serial* io, Serial pc, char* buffer){
    // Send escape sequence
    wait(1.5);
    io->printf("+++");
    wait(1.5);
    collectResponseString(io, buffer, BUFFER_SIZE, 15000, 0);
    pc.printf("%s", buffer);
   
    // Get socket status
    io->printf("AT#SS\r");
    collectResponseString(io, buffer, BUFFER_SIZE, 1000, 0);
    pc.printf("%s", buffer);
    
    // Reboot the modem
    pc.printf("Performing hard reset of the modem and waiting 10 seconds. \r\n");
    io->printf("AT#REBOOT\r");
    collectResponseString(io, buffer, BUFFER_SIZE, 1000, 0);
    pc.printf("%s", buffer);
    
    wait(10.0);
    
    pc.printf("Restarting the program...\r\n");
    
}

bool collectResponseString(Serial* io, char* buffer, int size, int timeout_ms, char terminator) {
    mbed::Timer tmr;
    tmr.start();
    int i = 0;
    char byte;
    bool notimeout = true;
    while (i < size-1) {
        if (tmr.read_ms() > timeout_ms) {
            notimeout = false;
            break;
        }
        if (io->readable()) {
            byte = io->getc();
            buffer[i] = byte;
            i++;
            if (byte == terminator) {
                break;    
            }
        }
    }
    buffer[i] = '\0';
    return notimeout;
}