#include "mbed.h"
#include "MPL3115A2.h"
#include "htu21d.h"


I2C i2c(I2C_SDA, I2C_SCL);       // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
MPL3115A2 mpl(&i2c, &pc);
htu21d htu(i2c);
DigitalOut bled(PTC3);
DigitalOut gled(PTC12);
AnalogIn light(A1);
AnalogIn lightref(A3);

float readLightSensor(AnalogIn sig, AnalogIn ref);

int main() {
    pc.baud(115200);
    wait_ms(300);
    gled.write(1);
    bled.write(1);

 
    pc.printf("** Temperature Shield **\r\n");
 
 
    // Initialize the MPL3115A2 pressure and temp.
    Temperature t;
    Pressure p;
    
    mpl.init();
    pc.printf("MPL3115A2 ID: 0x%X\r\n", mpl.whoAmI());
    // Offsets for Dacula, GA
    mpl.setOffsetTemperature(20);
    mpl.setOffsetPressure(-32);
   
   
     //initialize the HTU21D humidity and temp.
    float H21Temp = 0.0;                      //Temperture from HTU21D
    float H21Hum = 0.0;                       //Humidity from HTU21D
    int htu21 = htu.softReset();
    if(htu21 == 0){
        pc.printf(" - HTU21D broken...\r\n");
    } 
    else{
         uint8_t HTU21DuserReg = htu.getUserReg();
         pc.printf("HTU21D UserReg: 0x%02x   SN: 0x%04x %08x %04x\r\n", 
                   HTU21DuserReg, htu.HTU21sn.HTU21D_sna, htu.HTU21sn.HTU21D_snb, htu.HTU21sn.HTU21D_snc);
    }
    
    //main loop
    while(1) 
    {   
        //read mpl
        bled = 0;
        wait(1);
        mpl.readTemperature(&t);
        mpl.readPressure(&p);
        bled = 1;
        pc.printf("Temp: %s C, Pressure: %sPa \r\n", t.print(), p.print());

        //read htu
        gled = 0;
        wait(1);
        if(htu21 == 1) {    //if HTU21D didn't initialize, don't access HTU21D anymore
            H21Hum = htu.getHum();
            if((double)H21Hum == 255.0) pc.printf("\r\n*** HTU21D Hum error!!\r\n");
            H21Temp = htu.getTemp();
            if((double)H21Temp == 255.0) pc.printf("\r\n*** HTU21D Temp error!!\r\n");
        }
        gled = 1;
        pc.printf("Temp: %7.2f C   Hum: %4.1f %% \r\n ", H21Temp, H21Hum);
        
        //read photoresistor
        wait(1);
        float lightLvl = readLightSensor(light,lightref);
        pc.printf("Light: %3.2f \r\n", lightLvl);

    }
}

float readLightSensor(AnalogIn sig, AnalogIn ref){
    float opVoltage = 3.3/ref.read();
    float lightSen = opVoltage *sig.read();
    return lightSen;
    }