#include "SX1508.h"

SX1508::SX1508(PinName sda, PinName scl, char adr) : i2c (sda, scl), _slaveAddress(adr << 1)
{
    i2c.frequency(SX1508_FREQ);
    
    if (i2c.read(_slaveAddress, &data[0], 1) != 0) printf(RED "I2C device is not detected\r\n" DEF);
    else printf(GRE "I2C device is detected\r\n" DEF);
        
    data[0] = 0;
}

SX1508::~SX1508()
{
    
}

bool SX1508::WriteReg(char RegAdr, char data)
{
    w[0] = RegAdr;
    w[1] = data;
    if (i2c.write(_slaveAddress, w, 2) != 0) return 0;
    
    return true;
}

void SX1508::WriteBlk(char RegAdr, const char *data, int len)
{
    int i;
  
    i2c.start();
    i2c.write(_slaveAddress); 
    i2c.write(RegAdr);

    for (i=0; i<len; i++)
    {
        i2c.write(data[i]);
        wait_ms(1);
    }
    
    i2c.stop();
}

char SX1508::ReadReg(char RegAdr)
{
    char start = RegAdr;
    if (i2c.write(_slaveAddress, &start, 1, true) != 0) return 0;
    if (i2c.read(_slaveAddress, r, 1) != 0) return 0;
    
    return r[0];
}

bool SX1508::keypad_config(int column, int row, int Debounce_ms, int ScanTime_ms)
{
    if(Debounce_ms > ScanTime_ms)
    {
        printf(RED "Debounce Time must slower than ScanTime_ms\r\n" DEF);
        return 0;
    }
    
    if(!WriteReg(RegDir, 0xF0)) return 0;               // Set RegDir(0x07) to 0xF0 (IO[3-0] as outputs, IO[7-4] as inputs)
    if(!WriteReg(RegOpenDrain, 0x0F)) return 0;         // Set RegOpenDrain to 0x0F (IO[3-0] as open-drain outputs)
    if(!WriteReg(RegPullUp, 0xF0)) return 0;            // Set RegPullup to 0xF0 (pull-ups enabled on inputs IO[7-4])
    
    // set Clock's source
    if(!WriteReg(RegClock, 0x50)) return 0;             // Set RegClock to 0x50 for internal Clock 2MHz
    
    /**
        set Debounce time "RegDebounceConfig" 0x12 : RegDebounceConfig[2:0], RegDebounceConfig[7:3] Not Used = 0
    **/
    char debounce_config = 0x00;
    if      (Debounce_ms == 1)  debounce_config = debounce_config | 0x01;
    else if (Debounce_ms == 2)  debounce_config = debounce_config | 0x02;
    else if (Debounce_ms == 4)  debounce_config = debounce_config | 0x03;
    else if (Debounce_ms == 8)  debounce_config = debounce_config | 0x04;
    else if (Debounce_ms == 16) debounce_config = debounce_config | 0x05;
    else if (Debounce_ms == 32) debounce_config = debounce_config | 0x06;
    else if (Debounce_ms == 64) debounce_config = debounce_config | 0x07;
    else debounce_config = debounce_config | 0x04;
    
    if(!WriteReg(RegDebounceEnable, 0xF0)) return 0;    // RegDebounceEnable = 0xF0
    if(!WriteReg(RegDebounceConfig, debounce_config)) return 0;    // RegDebounceConfig = 0x04.
    
    /** 
        Set Number of row, Number of column, and time for scan a row
        - set row       : RegKeyConfig[6:5], RegKeyConfig[7] not used = 0;
        - set column    : RegKeyConfig[4:3]
        - set scan time : RegKeyConfig[0:2]
    **/
    char key_config = 0x00;
    if      (row == 0)  return 0; // scan key disable
    else if (row == 2)  key_config = key_config | 0x20;
    else if (row == 3)  key_config = key_config | 0x40;
    else if (row == 4)  key_config = key_config | 0x60;
    else    key_config = key_config | 0x60;
    
    if      (column == 1)  key_config = key_config | 0x00;
    else if (column == 2)  key_config = key_config | 0x08;
    else if (column == 3)  key_config = key_config | 0x10;
    else if (column == 4)  key_config = key_config | 0x18;
    else    key_config = key_config | 0x18;
    
    if      (ScanTime_ms == 1)   key_config = key_config | 0x00;
    else if (ScanTime_ms == 2)   key_config = key_config | 0x01;
    else if (ScanTime_ms == 4)   key_config = key_config | 0x02;
    else if (ScanTime_ms == 8)   key_config = key_config | 0x03;
    else if (ScanTime_ms == 16)  key_config = key_config | 0x04;
    else if (ScanTime_ms == 32)  key_config = key_config | 0x05;
    else if (ScanTime_ms == 64)  key_config = key_config | 0x06;
    else if (ScanTime_ms == 128) key_config = key_config | 0x07;
    else key_config = key_config | 0x04;
    
    if(!WriteReg(RegKeyConfig, key_config)) return 0;         // Enable and configure keypad scanning engine. 
    
    return true;
}

char SX1508::read()
{
    char data_read = ReadReg(RegKeyData);
    data_read = data_read & 0xFF;
    
    return data_read;
}