#ifndef SX1508_H
#define SX1508_H

#include "mbed.h"
#include "debug.h"

#define SX1508_FREQ 100000
#define SX1508_ADDR_1   0x20
#define SX1508_ADDR_2   0x21
#define SX1508_ADDR_3   0x22
#define SX1508_ADDR_4   0x23

class SX1508
{
public:
    enum RegName
    {
        // Register I/O Bank
        RegInputDisable     = 0x00,
        RegLongSlew         = 0x01,
        RegLowDrive         = 0x02,
        RegPullUp           = 0x03,
        RegPullDown         = 0x04,
        RegOpenDrain        = 0x05,
        RegPolarity         = 0x06,
        RegDir              = 0x07,
        RegData             = 0x08,
        RegInterruptMask    = 0x09,
        RegSenseHigh        = 0x0A,
        RegSenseLow         = 0x0B,
        RegInterruptSource  = 0x0C,
        RegEventStatus      = 0x0D,
        RegLevelShifter     = 0x0E,
        RegClock            = 0x0F,
        RegMisc             = 0x10,
        RegLEDDriverEnable  = 0x11,
        
        // Debounce and Keypad register
        RegDebounceConfig   = 0x12,
        RegDebounceEnable   = 0x13,
        RegKeyConfig        = 0x14,
        RegKeyData          = 0x15,
        
        // LED Driver (PWM, blinking, breathing)
        RegIOn0             = 0x16,
        RegIOn1             = 0x17,
        RegTOn2             = 0x18,
        RegIOn2             = 0x19,
        RegOff2             = 0x1A,
        RegTOn3             = 0x1B,
        RegIOn3             = 0x1C,
        RegOff3             = 0x1D,
        RegTRise3           = 0x1E,
        RegTFall3           = 0x1F,
        RegIOn4             = 0x20,
        RegIOn5             = 0x21,
        RegTOn6             = 0x22,
        RegIOn6             = 0x23,
        RegOff6             = 0x24,
        RegTOn7             = 0x25,
        RegIOn7             = 0x26,
        RegOff7             = 0x27,
        RegTRise7           = 0x28,
        RegTFall7           = 0x29,
        
        // Miscellaneous
        RegHighInput        = 0x2A,
        
        //Software Reset
        RegReset            = 0x7D,
        
        // Test (not to be written)
        RegTest1            = 0x7E,
        RegTest2            = 0x7F,
    };
    
    enum W_R
    {
        _write = 0x00,
        _read  = 0x01,
    };
    
    SX1508(PinName sda, PinName scl, char adr = SX1508_ADDR_1);
    ~SX1508();
    
    bool keypad_config(int column = 4, int row = 4, int Debounce_ms = 8, int ScanTime_ms = 32);
    char read();
    bool WriteReg(char RegAdr, char data);
    void WriteBlk(char RegAdr, const char *data, int len);
    char ReadReg(char RegAdr);
    
private:
    I2C i2c;
    char data[64];
    char w[32];
    char r[32];
    char _slaveAddress;
};

#endif