#ifndef PCF8563_H
#define PCF8563_H

#define W8563_ADDR     0xA2    // I2C address for write
#define R8563_ADDR     0xA3    // I2C address for read
#define PCF8563_FREQ     400000  // bus speed 400 kHz

class PCF8563
{
public:
    PCF8563(PinName sda, PinName scl);

    /** Read current real time from PCF8563
     *
     * @returns
     *   current time on success,
     *   0 on error (I2C fail, clock not set)
     */
    time_t now();
    
    /** Write current real time to PCF8563
     *
     * @param time Real time to set up
     * @returns
     *   true on success,
     *   false on error (I2C fail)
     */
    bool set_time(time_t time);
    
    /** Write alarm time to PCF8563
     * @param time is set time for alarm
     * @returns
     *    true on success,
     *    false on error
     */
    bool set_alarm(time_t time);
    
    /**
     */
    bool alarmOff();
    
    /**
     */
    bool check_alarm();
    
    /**
     */
    
private:
    I2C pcf8563_i2c;

    static int bcdToDecimal(int bcd) {
        return ((bcd & 0xF0) >> 4) * 10 + (bcd & 0x0F);
    }

    static int decimalToBcd(int dec) {
        return (dec % 10) + ((dec / 10) << 4);
    }
};

#endif
