#ifndef PCF85263AT_H
#define PCF85263AT_H

#include "mbed.h"

#define address 0xA2

class PCF85263AT
{
public:
    
    enum RegisterName
    {
        // Time and Date Register			| Bit 7 | Bit 6 | Bit 5 | Bit 4 | Bit 3 | Bit 2 | Bit 1 | Bit 0 |
		MSEC		= 0x00, // Mili Second	|                           ( 0 - 99 )                          |
        SEC         = 0x01, // Second       |   OS  |                       ( 0 - 59 )                      |
        MIN         = 0x02, // Minute       | EMON  |                       ( 0 - 59 )                      |
        HOUR        = 0x03, // Hour         |   X   |   X   | AM/PM |       ( 1 - 12 )                      |
                            // Hour         |   X   |   X   |               ( 0 - 23 )                      |
        DAY         = 0x04, // Day          |   X   |   X   |               ( 1 - 31 )                      |
        WDAY        = 0x05, // Day of week  |   X   |   X   |   X   |   X   |   X   |       ( 0 - 6 )       |
        MONTH       = 0x06, // month        |   X   |   X   |   X   |               ( 1 - 12 )              |
        YEAR        = 0x07, // year         |                           ( 0 - 99 )                          |
        
        // Alarm1 register
		SECALARM	= 0x08,	// Second1		|   X   |                       ( 0 - 59 )                      |
        MINALARM    = 0x09, // Minute1      |   X   |                       ( 0 - 59 )                      |
        HOURALARM   = 0x0A, // Hour1        |   X   |   X   | AM/PM |       ( 1 - 12 )                      |
                            // Hour1        |   X   |   X   |               ( 0 - 23 )                      |
        DAYALARM    = 0x0B, // Day          |   X   |   X   |               ( 1 - 31 )                      |
        MONALARM    = 0x0C, // Day of week  |   X   |   X   |   X   |               ( 1 - 12 )              |
		
		// Alarm2 register
        MINALARM2   = 0x0D, // Minute1      |   X   |                       ( 0 - 59 )                      |
        HOURALARM2  = 0x0E, // Hour1        |   X   |   X   | AM/PM |       ( 1 - 12 )                      |
        WDAYALARM2  = 0x0F, // Day          |   X   |   X   |   X   |   X   |   X   |       ( 0 - 6 )       |
		
		// RTC Alarm Enable
		ALARMEN		= 0x10,	// Alarm Enable	|WDAY2E | HR2E  | MIN2E | MON1E | DAYE  | HR1E  | MIN1E | SEC1E |
		
		// OFFSET Register
        OFFSET      = 0x24, // Offset       |								[7:0]							|
		
		// CONTROL REGISTER
		OSCI		= 0x25, // Oscilator	| CLKIV | OFFM  | 12_24 |  LOWJ |   OSCD[1:0]   |    CL[1:0]    |
		BTRSW		= 0x26, // BatterySwitch|   X   |   X   |   X   | BSOFF | BSRR  |   BSM[1:0]    | BSTH  |
        PINIO       = 0x27, // Pin I/O      | CLKPM | TSPULL| TSL   | TSIM  |   TSPM[1:0]   | INTAPM[1:0]   |
		FUNCT		= 0x28, // Fungtion		| 100TH |   PI [2:0]    |  RTCM | STOPM |        COF[2:0]       |
		FLAG		= 0x2B, // Flags		|  PIF  |  A2F  |  A1F  |  WDF  |  BSF  | TSR3F | TSR2F | TSR1F |
		
		// STOP
		STOPEN		= 0x2E, // Stop Enable	|   X   |   X   |   X   |   X   |   X   |   X   |   X   |  STOP |
		
		// RESET
        RESET       = 0x2F // Reset RTC    |  CPR  |   0   |   1   |   0   |  SR   |   1   |   0   |  CTS  |
    };
    
    bool write(char adr, char data);
    char read(char adr);
    time_t now();
    bool set_time(time_t time);
    bool IsConnected();
    bool software_reset();
    
    PCF85263AT(PinName sda, PinName scl);
    ~PCF85263AT();
    
private:
    I2C i2c;
    char data[64];
    char w[32];
    char r[32];
    
    static int bcdToDecimal(int bcd) {
        return ((bcd & 0xF0) >> 4) * 10 + (bcd & 0x0F);
    }

    static int decimalToBcd(int dec) {
        return (dec % 10) + ((dec / 10) << 4);
    }
};

#endif // PCF85263AT_H
