#include "PCA9535.h"

extern Serial dbg;

PCA9535::PCA9535(PinName sda, PinName scl):i2c(sda, scl)
{
    i2c.frequency(PCA9535_FREQ);
}

PCA9535::~PCA9535()
{
    
}

bool PCA9535::configure(char pin1, char pin2)
{
    char data1 = pin1;
    char data2 = pin2;
    
    char buffer[3];
    
    buffer[0] = 0x06;
    buffer[1] = data1;
    buffer[2] = data2;
    
    dbg.printf("%.2X %.2X %.2X\r\n", buffer[0], buffer[1], buffer[2]);
    if(i2c.write(ADDR, buffer, 3) != 0)return 0;
    
    return 1;
}

bool PCA9535::write(char pin1, char pin2)
{
    char buffer[3];
    buffer[0] = 0x02;
    buffer[1] = pin1;
    buffer[2] = pin2;
    
    dbg.printf("%.2X %.2X %.2X\r\n", buffer[0], buffer[1], buffer[2]);
    if(i2c.write(ADDR, buffer, 3) != 0)return 0;
    
    return 1;
}

int PCA9535::read()
{
    char start = 0x00;
    char buffer[2];
    
    if(i2c.write(ADDR, &start, 1) != 0)return 0;
    if(i2c.read(ADDR, buffer, 2) != 0)return 0;
    
    int val = (int) (buffer[0] * 256) + buffer[1];
    
    return val;
}