#ifndef PCA9535_H
#define PCA9535_H

#include "mbed.h"

#define ADDR 0x40
#define PCA9535_FREQ 100000
class PCA9535
{
public:
    /** Name of PCA9535 register **/
    enum command_reg
    {
        InputPort0              = 0x00, /**< InputPort0 register                */
        InputPort1,                     /**< InputPort1 register                */
        OutoutPort0,                    /**< OutoutPort0 register               */
        OutoutPort1,                    /**< OutoutPort1 register               */
        PolarityInversionPort0,         /**< PolarityInversionPort0 register    */
        PolarityInversionPort1,         /**< PolarityInversionPort1 register    */
        ConfigurationPort0,             /**< ConfigurationPort0 register        */
        ConfigurationPort1,             /**< ConfigurationPort1 register        */
    };
    
    
    typedef enum {
        X0_0,           /**< P0_0 pin */
        X0_1,           /**< P0_1 pin */
        X0_2,           /**< P0_2 pin */
        X0_3,           /**< P0_3 pin */
        X0_4,           /**< P0_4 pin */
        X0_5,           /**< P0_5 pin */
        X0_6,           /**< P0_6 pin */
        X0_7,           /**< P0_7 pin */
        X1_0,           /**< P1_0 pin */
        X1_1,           /**< P1_1 pin */
        X1_2,           /**< P1_2 pin */
        X1_3,           /**< P1_3 pin */
        X1_4,           /**< P1_4 pin */
        X1_5,           /**< P1_5 pin */
        X1_6,           /**< P1_6 pin */
        X1_7,           /**< P1_7 pin */
        X0  = X0_0,     /**< P0_0 pin */
        X1  = X0_1,     /**< P0_1 pin */
        X2  = X0_2,     /**< P0_2 pin */
        X3  = X0_3,     /**< P0_3 pin */
        X4  = X0_4,     /**< P0_4 pin */
        X5  = X0_5,     /**< P0_5 pin */
        X6  = X0_6,     /**< P0_6 pin */
        X7  = X0_7,     /**< P0_7 pin */
        X8  = X1_0,     /**< P1_0 pin */
        X9  = X1_1,     /**< P1_1 pin */
        X10 = X1_2,     /**< P1_2 pin */
        X11 = X1_3,     /**< P1_3 pin */
        X12 = X1_4,     /**< P1_4 pin */
        X13 = X1_5,     /**< P1_5 pin */
        X14 = X1_6,     /**< P1_6 pin */
        X15 = X1_7,     /**< P1_7 pin */

        X_NC = ~0x0L    /**< for when the pin is left no-connection */
    } GpioPinName;
    
    PCA9535( PinName sda, PinName scl);
    ~PCA9535();
    
    bool configure(char pin1, char pin2);
    
    bool write(char pin1, char pin2);
    
    int read();
private:
    I2C i2c;
    char PCA9535_ADDR;
};
#endif