#include "mbed.h"
#include "tampil.h"
#include "query.h"
#include <sstream>

extern Serial dsp;
extern Serial dbg;

Noritake_VFD_GU7000 vfd;

uint8_t bar[] = {0x03, 0x03, 0x00, 0x0f, 0x0f, 0x00, 0x3f, 0x3f, 0x00, 0xff, 0xff, 0x00};
uint8_t bar0[] = {0x00, 0x00, 0x00, 0x00, 0x00};
uint8_t bar1[] = {0x01, 0x01, 0x01, 0x01, 0x01};
uint8_t bar2[] = {0x05, 0x05, 0x05, 0x05, 0x05};
uint8_t bar3[] = {0x15, 0x15, 0x15, 0x15, 0x15};
// saat signal > 3 maka bar3 akan dikombinasikan dengan bar4 atau bar5
uint8_t bar4[] = {0x55, 0x55, 0x55, 0x55, 0x55};
uint8_t bar5[] = {0x55, 0x55, 0x55, 0x55, 0x55};


std::string Convertint(int data)
{
    std::stringstream c;
    c << data;
    return c.str();
}

void display_init()
{
    vfd.GU7000_cursorOff();
    vfd.GU7000_clearScreen();
}

void displayActive()
{
    vfd.GU7000_setFontSize(1,1,false);
    vfd.GU7000_setCursor(60,8);
    vfd.print("       ");
    wait_us(100000);
}

void display_idle()
{
    vfd.GU7000_setCursor(0,0);
    vfd.GU7000_setFontSize(2,2,false);
    vfd.print("-- -- --");
}

void displayChn(int chInd)
{
    std::string ch;
    ch += "CH";
    
    if(chInd <= 9)
    {
        ch += " ";
        ch += Convertint(chInd);
    }
    else ch += Convertint(chInd);
    
    vfd.GU7000_setCursor(0,0);
    vfd.GU7000_setFontSize(2,2,false);
    vfd.print(ch.c_str());
}

void displaySig(int sig)
{
    /*
    vfd.GU7000_setCursor(100,0);
    vfd.GU7000_drawImage(3*sig, 0x08, bar);
    
    if(sig <= -105)
    {
        vfd.GU7000_setCursor(106,0);
        vfd.GU7000_drawImage(5, 0x08, bar0);
    }
    else if((sig > -105) && (sig < -93))
    {
        vfd.GU7000_setCursor(106,0);
        vfd.GU7000_drawImage(5, 0x08, bar1);
    }
    else if((sig >= -93) && (sig < -81))
    {
        vfd.GU7000_setCursor(106,0);
        vfd.GU7000_drawImage(5, 0x08, bar2);
    }
    else if((sig >= -81) && (sig < -69))
    {
        vfd.GU7000_setCursor(106,0);
        vfd.GU7000_drawImage(5, 0x08, bar3);
    }
    else if((sig >= -69) && (sig < -57))
    {
        vfd.GU7000_setCursor(106,0);
        vfd.GU7000_drawImage(5, 0x08, bar4);
        
    }
    else if(sig >= -57)
    {
        vfd.GU7000_setCursor(106,0);
        vfd.GU7000_drawImage(5, 0x08, bar5);
    }*/
    switch(sig)
    {
        case 0:{
            vfd.GU7000_setCursor(106,0);
            vfd.GU7000_drawImage(5, 0x08, bar0);
            break;
        }
        case 1:{
            vfd.GU7000_setCursor(106,0);
            vfd.GU7000_drawImage(5, 0x08, bar1);
            break;
        }
        case 2:{
            vfd.GU7000_setCursor(106,0);
            vfd.GU7000_drawImage(5, 0x08, bar2);
            break;
        }
        case 3:{
            vfd.GU7000_setCursor(106,0);
            vfd.GU7000_drawImage(5, 0x08, bar3);
            break;
        }
        case 4:{
            vfd.GU7000_setCursor(106,0);
            vfd.GU7000_drawImage(5, 0x08, bar4);
            break;
        }
        case 5:{
            vfd.GU7000_setCursor(106,0);
            vfd.GU7000_drawImage(5, 0x08, bar5);
            break;
        }
    }
}

void displaySts(const char *sts)
{
    vfd.GU7000_setFontSize(1,1,false);
    vfd.GU7000_setCursor(60,8);
    vfd.print(sts);
    // ada tanda untuk menandakan display aktif
}

void displaySts(int status)
{
    const char *sts;
    
    switch(status)
        {
            case 0:{
                sts = "CONNECT";
                break;
            }
            case 2:{
                sts = "WAITING";
                break;
            }
            case 3:{
                sts = "CONNECT";
                break;
            }
            case 4:{
                // mdm.mute(0); mute untuk menghilangkan suara dering dll. 0 = normal, 1 = mute.
                // using => AT+CALM=<value>, AT+CLVL=80, AT+CMUT=0, 
                sts = "CALL IN";
                break;
            }
            case 6:{
                //mdm.mute(1);
                // AT+CALM=1, AT+CLVL=0, AT+CMUT=1, 
                sts = "READY";
                break;
            }
        }
        
    vfd.GU7000_setFontSize(1,1,false);
    /*vfd.GU7000_setCursor(60,8);
    vfd.print("       ");
    wait_us(10000);*/
    vfd.GU7000_setCursor(60,8);
    vfd.print(sts);
}

void displayImg(uint8_t * img, unsigned x, unsigned y, int width)
{
    vfd.GU7000_setCursor(x,y);
    vfd.GU7000_drawImage(width, 0x08, img);
    wait_us(200);
}

void displayClr()
{
    vfd.GU7000_setFontSize(2,2,false);
    vfd.print("        ");
    vfd.GU7000_setFontSize(1,1,false);
    vfd.GU7000_clearScreen();   
}

void displayStd(time_t &dt)
{
    tm *ptm = localtime(&dt);
    char buf1[20];
    char buf2[20];
    strftime(buf1,20,"%H:%M", ptm);
    strftime(buf2,20,"%H %M", ptm);
    vfd.GU7000_setFontSize(3,2,false);
    vfd.print(buf1);
    wait_us(100000);
    vfd.print(buf2);
}