/*
    This Library for ADC MCP3424.
    I modif from ibrary at https://github.com/battosai30/MCP3424
    I wish it's working good.
*/

#ifndef MCP3424_H
#define MCP3424_H

#include "mbed.h"
//#include <math.h>

#define MCP3424_ADDR     0xD0
#define MCP3424_FREQ     100000

class MCP3424 {

public:
    
    MCP3424(PinName sda, PinName scl);
    ~MCP3424();
    bool Config(uint8_t channel,uint8_t resolution,bool mode,uint8_t PGA);
    bool NewConversion();
    bool IsConversionFinished();
    long Measure();
    
private:
    
    I2C mcp3424_i2c;
    
    uint8_t _adresse;
    long _resultat;
    uint8_t _resolution;
    bool _mode;
    uint8_t _i;
    uint8_t _testvariable;
    uint8_t _cfgbyte;
    uint8_t _PGA;
    uint8_t _RequestedByte;
    uint8_t _Buffer[4];
    char _recvBuff[8];
    long _res;
};

#endif